import { CodeEditor } from '@jupyterlab/codeeditor';
import { EditorSearchProvider } from '@jupyterlab/codemirror';
import { IBaseSearchProvider } from '@jupyterlab/documentsearch';
import { ICellModel } from './model';
import { Cell } from './widget';
/**
 * Class applied on highlighted search matches
 */
export declare const SELECTED_HIGHLIGHT_CLASS = "jp-mod-selected";
/**
 * Search provider for cells.
 */
export declare class CellSearchProvider extends EditorSearchProvider<ICellModel> implements IBaseSearchProvider {
    protected cell: Cell<ICellModel>;
    constructor(cell: Cell<ICellModel>);
    /**
     * Text editor
     */
    protected get editor(): CodeEditor.IEditor | null;
    /**
     * Editor content model
     */
    protected get model(): ICellModel;
}
/**
 * Factory to create a cell search provider
 *
 * @param cell Cell widget
 * @returns Cell search provider
 */
export declare function createCellSearchProvider(cell: Cell<ICellModel>): CellSearchProvider;
