import * as React from 'react';
import { TableOfContents } from './tokens';
/**
 * Interface describing component properties.
 */
export interface ITableOfContentsItemsProps {
    /**
     * Whether this item is active or not.
     */
    isActive: boolean;
    /**
     * Heading to render.
     */
    heading: TableOfContents.IHeading;
    /**
     * On `mouse-down` event callback.
     */
    onMouseDown: (heading: TableOfContents.IHeading) => void;
    /**
     * Collapse event callback.
     */
    onCollapse: (heading: TableOfContents.IHeading) => void;
}
/**
 * React component for a table of contents entry.
 */
export declare class TableOfContentsItem extends React.PureComponent<React.PropsWithChildren<ITableOfContentsItemsProps>> {
    /**
     * Renders a table of contents entry.
     *
     * @returns rendered entry
     */
    render(): JSX.Element | null;
}
