// SPDX-FileCopyrightText: 2021-2023 deroad <wargio@libero.it>
// SPDX-FileCopyrightText: 2023 Dhruv Maroo <dhruvmaru007@gmail.com>
// SPDX-License-Identifier: LGPL-3.0-only

#include "minunit.h"

mu_demangle_tests(rust,
	// Legacy tests.
	mu_demangle_test("_ZN5alloc3oom3oom17h722648b727b8bcd0E", "alloc::oom::oom::h722648b727b8bcd0"),
	mu_demangle_test("__ZN4core3fmt5Write10write_char17hcc5144a9a84f2b15E", "core::fmt::Write::write_char::hcc5144a9a84f2b15"),
	mu_demangle_test("ZN14rustc_demangle6legacy8demangleE", "rustc_demangle::legacy::demangle"),
	mu_demangle_test("_ZN4toolongE", NULL),
	mu_demangle_test("___ZNwrong_formatE", NULL),
	mu_demangle_test("_ZN10no_e_found", NULL),
	mu_demangle_test("_ZN7onlyone", NULL),
	mu_demangle_test("_ZN4$RP$E", ")"),
	mu_demangle_test("_ZN8$RF$testE", "&test"),
	mu_demangle_test("_ZN8$BP$test4foobE", "*test::foob"),
	mu_demangle_test("_ZN9$u20$test4foobE", " test::foob"),
	mu_demangle_test("_ZN35Bar$LT$$u5b$u32$u3b$$u20$4$u5d$$GT$E", "Bar<[u32; 4]>"),
	mu_demangle_test("_ZN13test$u20$test4foobE", "test test::foob"),
	mu_demangle_test("_ZN12test$BP$test4foobE", "test*test::foob"),
	mu_demangle_test("__ZN5alloc9allocator6Layout9for_value17h02a996811f781011E", "alloc::allocator::Layout::for_value::h02a996811f781011"),
	mu_demangle_test("__ZN38_$LT$core..option..Option$LT$T$GT$$GT$6unwrap18_MSG_FILE_LINE_COL17haf7cb8d5824ee659E", "<core::option::Option<T>>::unwrap::_MSG_FILE_LINE_COL::haf7cb8d5824ee659"),
	mu_demangle_test("__ZN4core5slice89_$LT$impl$u20$core..iter..traits..IntoIterator$u20$for$u20$$RF$$u27$a$u20$$u5b$T$u5d$$GT$9into_iter17h450e234d27262170E", "core::slice::<impl core::iter::traits::IntoIterator for &'a [T]>::into_iter::h450e234d27262170"),
	mu_demangle_test("ZN4testE", "test"),
	mu_demangle_test("ZN13test$u20$test4foobE", "test test::foob"),
	mu_demangle_test("ZN12test$RF$test4foobE", "test&test::foob"),
	mu_demangle_test("_ZN13_$LT$test$GT$E", "<test>"),
	mu_demangle_test("_ZN28_$u7b$$u7b$closure$u7d$$u7d$E", "{{closure}}"),
	mu_demangle_test("_ZN15__STATIC_FMTSTRE", "__STATIC_FMTSTR"),
	mu_demangle_test("_ZN71_$LT$Test$u20$$u2b$$u20$$u27$static$u20$as$u20$foo..Bar$LT$Test$GT$$GT$3barE", "<Test + 'static as foo::Bar<Test>>::bar"),
	mu_demangle_test("_ZN3foo17h05af221e174051e9E", "foo::h05af221e174051e9"),
	mu_demangle_test("_ZN3fooE", "foo"),
	mu_demangle_test("_ZN3foo3barE", "foo::bar"),
	mu_demangle_test("_ZN3foo20h05af221e174051e9abcE", "foo::h05af221e174051e9abc"),
	mu_demangle_test("_ZN3foo5h05afE", "foo::h05af"),
	mu_demangle_test("_ZN17h05af221e174051e93fooE", "h05af221e174051e9::foo"),
	mu_demangle_test("_ZN3foo16ffaf221e174051e9E", "foo::ffaf221e174051e9"),
	mu_demangle_test("_ZN3foo17hg5af221e174051e9E", "foo::hg5af221e174051e9"),
	mu_demangle_test("_ZN3fooE.llvm.9D1C9369", "foo"),
	mu_demangle_test("_ZN3fooE.llvm.9D1C9369@@16", "foo"),
	mu_demangle_test("_ZN9backtrace3foo17hbb467fcdaea5d79bE.llvm.A5310EB9", "backtrace::foo::hbb467fcdaea5d79b"),
	mu_demangle_test("_ZN4core5slice77_$LT$impl$u20$core..ops..index..IndexMut$LT$I$GT$$u20$for$u20$$u5b$T$u5d$$GT$9index_mut17haf9727c2edfbc47bE.exit.i.i", "core::slice::<impl core::ops::index::IndexMut<I> for [T]>::index_mut::haf9727c2edfbc47b.exit.i.i"),
	mu_demangle_test("_ZN3fooE.llvm moocow", NULL),
	mu_demangle_test("_ZN2222222222222222222222EE", NULL),
	mu_demangle_test("_ZN5*70527e27.ll34csaғE", NULL),
	mu_demangle_test("_ZN5*70527a54.ll34_$b.1E", NULL),
	mu_demangle_test("_ZNfooE", NULL),
	mu_demangle_test("_ZN151_$LT$alloc..boxed..Box$LT$alloc..boxed..FnBox$LT$A$C$$u20$Output$u3d$R$GT$$u20$$u2b$$u20$$u27$a$GT$$u20$as$u20$core..ops..function..FnOnce$LT$A$GT$$GT$9call_once17h69e8f44b3723e1caE", "<alloc::boxed::Box<alloc::boxed::FnBox<A, Output=R> + 'a> as core::ops::function::FnOnce<A>>::call_once::h69e8f44b3723e1ca"),
	mu_demangle_test("_ZN88_$LT$core..result..Result$LT$$u21$$C$$u20$E$GT$$u20$as$u20$std..process..Termination$GT$6report17hfc41d0da4a40b3e8E", "<core::result::Result<!, E> as std::process::Termination>::report::hfc41d0da4a40b3e8"),
	mu_demangle_test("_ZN11utf8_idents157_$u10e1$$u10d0$$u10ed$$u10db$$u10d4$$u10da$$u10d0$$u10d3$_$u10d2$$u10d4$$u10db$$u10e0$$u10d8$$u10d4$$u10da$$u10d8$_$u10e1$$u10d0$$u10d3$$u10d8$$u10da$$u10d8$17h21634fd5714000aaE", "utf8_idents::საჭმელად_გემრიელი_სადილი::h21634fd5714000aa"),
	mu_demangle_test("_ZN11issue_609253foo37Foo$LT$issue_60925..llv$u6d$..Foo$GT$3foo17h059a991a004536adE", "issue_60925::foo::Foo<issue_60925::llvm::Foo>::foo::h059a991a004536ad"),
	mu_demangle_test("_ZN4test1a2bcE", "test::a::bc"),
	mu_demangle_test("_ZN4testE", "test"),
	mu_demangle_test("\
        _ZN5~saäb4e\n\
        2734cOsbE\n\
        5usage20h)3\0\0\0\0\0\0\07e2734cOsbE\
        ",
		NULL),

	// v0 mangling tests.
	mu_demangle_test("_RNvC6_123foo3bar", "123foo::bar"),
	mu_demangle_test("_RNCNCNgCs6DXkGYLi8lr_2cc5spawn00B5_", "cc[4d6468d6c9fd4bb3]::spawn::{closure#0}::{closure#0}"),
	mu_demangle_test("_RNCINkXs25_NgCsbmNqQUJIY6D_4core5sliceINyB9_4IterhENuNgNoBb_4iter8iterator8Iterator9rpositionNCNgNpB9_6memchr7memrchrs_0E0Bb_", "<core[846817f741e54dfd]::slice::Iter<u8> as core[846817f741e54dfd]::iter::iterator::Iterator>::rposition::<core[846817f741e54dfd]::slice::memchr::memrchr::{closure#1}>::{closure#0}"),
	mu_demangle_test("_RINbNbCskIICzLVDPPb_5alloc5alloc8box_freeDINbNiB4_5boxed5FnBoxuEp6OutputuEL_ECs1iopQbuBiw2_3std", "alloc[f15a878b47eb696b]::alloc::box_free::<dyn alloc[f15a878b47eb696b]::boxed::FnBox<(), Output = ()>>"),
	mu_demangle_test("_RNvNtNtNtNtCs92dm3009vxr_4rand4rngs7adapter9reseeding4fork23FORK_HANDLER_REGISTERED.0.0", "rand[693ea8e72247470f]::rngs::adapter::reseeding::fork::FORK_HANDLER_REGISTERED (.0.0)"),
	mu_demangle_test("_RC3foo.llvm.9D1C9369", "foo (.llvm.9D1C9369)"),
	mu_demangle_test("_RC3foo.llvm.9D1C9369@@16", "foo (.llvm.9D1C9369@@16)"),
	mu_demangle_test("_RNvC9backtrace3foo.llvm.A5310EB9", "backtrace::foo (.llvm.A5310EB9)"),
	mu_demangle_test("_RINtNtC3std4iter5ChainINtB2_3ZipINtNtB4_3vec8IntoItermEBt_EE", "std::iter::Chain::<std::iter::Zip<std::vec::IntoIter<u32>, _>>"),
	mu_demangle_test("_RINtNtC3std4iter5ChainINtNtC3std4iter3ZipINtNtC3std3vec8IntoItermEINtNtC3std3vec8IntoItermEEE", "std::iter::Chain::<std::iter::Zip<std::vec::IntoIter<u32>, std::vec::IntoIter<u32>>>"),
	mu_demangle_test("_RINvCs1234_7mycrate3fooNvB4_3barNvBn_3bazE", "mycrate[3c1c0]::foo::<::bar, ::baz>"),
	mu_demangle_test("_RINvNtC3std3mem8align_ofC3f16E", "std::mem::align_of::<f16>"),
	mu_demangle_test("_RINvNtC3std3mem8align_offE", "std::mem::align_of::<f32>"),
	mu_demangle_test("_RINvNtC3std3mem8align_ofdE", "std::mem::align_of::<f64>"),
	mu_demangle_test("_RINvNtC3std3mem8align_ofC4f128E", "std::mem::align_of::<f128>"),
	mu_demangle_test("_RINvNtC3std3mem8align_ofjE", "std::mem::align_of::<usize>"),
	mu_demangle_test("_RINvNtC3std3mem8align_ofjEC3bar", "std::mem::align_of::<usize>"),
	mu_demangle_test("_RINvNtC3std3mem8align_ofjEC3foo", "std::mem::align_of::<usize>"),
	mu_demangle_test("_RINvNtC3std3mem8align_ofNtNtC3std3mem12DiscriminantE", "std::mem::align_of::<std::mem::Discriminant>"),
	mu_demangle_test("_RINvNtC3std3mem8align_ofQTReuEE", "std::mem::align_of::<&mut (&str, ())>"),
	mu_demangle_test("_RINvNtC3std3mem8align_ofRcE", "std::mem::align_of::<&char>"),
	mu_demangle_test("_RINxC3std3fooTNyB4_3BarBe_EBd_E", "std::foo::<(::Bar, i16), u64>"),
	mu_demangle_test("_RNvMINtC7mycrate3FoomE3foo", NULL),
	mu_demangle_test("_RNvNtCs1234_7mycrate3foo3bar", "mycrate[3c1c0]::foo::bar"),
	mu_demangle_test("_RNvNtNtC7mycrateu8gdel_5qa6escher4bach", "mycrate::gödel::escher::bach"),
	mu_demangle_test("_RNvNtNtCs1234_7mycrate3foo3bar3baz", "mycrate[3c1c0]::foo::bar::baz"),
	mu_demangle_test("_RNvNvCs1234_7mycrate4QUUX3FOO", "mycrate[3c1c0]::QUUX::FOO"),
	mu_demangle_test("_RNvNvMCs1234_7mycrateINtCs1234_7mycrate3FoopE3bar4QUUX", "<mycrate[3c1c0]::Foo<_>>::bar::QUUX"),
	mu_demangle_test("_RNvNvXCs1234_7mycrateINtCs1234_7mycrate3FoopENtNtC3std5clone5Clone5clone4QUUX", "<mycrate[3c1c0]::Foo<_> as std::clone::Clone>::clone::QUUX"),
	mu_demangle_test("_RNvNvXINtC7mycrate3FoopEINtNtC3std7convert4FrompE4from3MSG", NULL),
	mu_demangle_test("_RNvNvXs2_C7mycrateINtC7mycrate3FoopEINtNtC3std7convert4FrompE4from3MSG", "<mycrate::Foo<_> as std::convert::From<_>>::from::MSG"),
	mu_demangle_test("_RNvNvXs3_C7mycrateINtC7mycrate3FoopEINtNtC3std7convert4FrompE4from3MSG", "<mycrate::Foo<_> as std::convert::From<_>>::from::MSG"),
	mu_demangle_test("_RNvXINtC7mycrate3FoomEINtC7mycrate3BaryE3foo", NULL),
	mu_demangle_test("_RNvXmNtC7mycrate3Foo3foo", NULL),
	mu_demangle_test("_RINvCs7qp2U7fqm6G_7mycrate7exampleFG0_RL1_hRL0_tEuEB2_", "mycrate[567e63b0a19c5b38]::example::<for<'a, 'b> fn(&'a u8, &'b u16)>"),
	mu_demangle_test("_RINvCs7qp2U7fqm6G_7mycrate7exampleKy12345678_EB2_", "mycrate[567e63b0a19c5b38]::example::<305419896>"),
	mu_demangle_test("_RNvNvMCsd9PVOYlP1UU_7mycrateINtB4_7ExamplepKpE3foo14EXAMPLE_STATIC", "<mycrate[99446627ef552b06]::Example<_, _>>::foo::EXAMPLE_STATIC"),
	mu_demangle_test("_RINvCs7qp2U7fqm6G_7mycrate7exampleAtj8_EB2_", "mycrate[567e63b0a19c5b38]::example::<[u16; 8]>"),
	mu_demangle_test("_RINvMsY_NtCseXNvpPnDBDp_3std4pathNtB6_4Path3neweECs7qp2U7fqm6G_7mycrate", "<std[ae4cfa2cb15e51b9]::path::Path>::new::<str>"),
	mu_demangle_test("_RNvNvNvCs7qp2U7fqm6G_7mycrate7EXAMPLE7___getit5___KEY$tlv$init", "mycrate[567e63b0a19c5b38]::EXAMPLE::__getit::__KEY ($tlv$init)"),
	mu_demangle_test("_RNvMsr_NtCs3ssYzQotkvD_3std4pathNtB5_7PathBuf3newCs15kBYyAo9fc_7mycrate", "<std[284a76a8b41a7fd3]::path::PathBuf>::new"),
	mu_demangle_test("_RINvCs7qp2U7fqm6G_7mycrate7exampleNtB2_7ExampleBw_EB2_", "mycrate[567e63b0a19c5b38]::example::<mycrate[567e63b0a19c5b38]::Example, mycrate[567e63b0a19c5b38]::Example>"),
	mu_demangle_test("_RNvCs15kBYyAo9fc_7mycrate7example", "mycrate[ca63f166dbe9294]::example"),
	// end
);

mu_main(rust, rust, RZ_DEMANGLE_OPT_BASE);
