---
title: pysh.utils
keywords: spherical harmonics, utilities, wigner symbols, python, pyshtools
sidebar: mydoc_sidebar
permalink: python-utilities.html
summary: This module provides miscellaneous routines that are useful when working with spherical harmonics and creating figures.
toc: false
folder: mydoc
---

<style>
table:nth-of-type(n) {
    display:table;
    width:100%;
}
table:nth-of-type(n) th:nth-of-type(2) {
    width:75%;
}
</style>

| Function name | Description |
| ------------- | ----------- |
| [MakeCircleCoord](pymakecirclecoord.html) | Compute coordinates of a circle placed at a given latitude and longitude. |
| [MakeEllipseCoord](pymakeellipsecoord.html) | Compute coordinates of an ellipse placed at a given latitude and longitude. |
| [Wigner3j](pywigner3j.html) | Compute the Wigner-3j symbols for all allowable values of *j*.|
| [DHaj](pydhaj.html) | Compute the latitudinal weights used in the Driscoll and Healy (1994) spherical harmonic transform. |
| [figstyle](figstyle.html) | Set matplotlib parameters for creating publication quality graphics. |
