# Public Domain CC0
%define _pkg_name viking
Name:       mingw32-%{_pkg_name}
Version:    1.11
Release:    1
Summary:    GPS data editor and analyzer
Group:      Applications/Productivity
License:    GPL-2.0-or-later
URL:        https://sourceforge.net/projects/viking/
Source0:    %{_pkg_name}-%{version}.tar.gz

# 32bit version only in this file. See mingw64-viking.spec for the 64bit version

# Programs to enable the cross build
BuildRequires:  mingw32-cross-gcc
BuildRequires:  mingw32-gettext-tools
BuildRequires:  intltool
BuildRequires:  libxslt-tools
BuildRequires:  glib2-devel
#^ For glib-compile-resources
BuildRequires:  vim
#^ Contains xxd command

# Code
# Not worried about versions ATM
BuildRequires:  mingw32-gtk3-devel
# ATM gtk3-devel auto includes at least devel versions of glib2, gobject, zlib and more

# Mandatory libraries
BuildRequires:  mingw32-json-glib-devel
BuildRequires:  mingw32-libexpat-devel
BuildRequires:  mingw32-libcurl-devel
# Optional libraries
BuildRequires:  mingw32-libgexiv2-devel
BuildRequires:  mingw32-libbz2-devel
BuildRequires:  mingw32-file-devel
BuildRequires:  mingw32-sqlite-devel
BuildRequires:  mingw32-libzip-devel
BuildRequires:  mingw32-libnettle-devel
BuildRequires:  mingw32-libgps-devel
BuildRequires:  mingw32-liboauth-devel
BuildRequires:  mingw32-libnova-devel
BuildRequires:  mingw32-xz-devel

%_mingw32_package_header_debug
BuildArch:      noarch

# Libs for runtime (and thus also available for the NSIS installer to include the dependencies)
# All should be auto detected
#Requires:   mingw32-gtk3
# mingw32-libcurl4, mingw32-libgexiv2, etc...

# Currently running makensis in seperate script - so you will need it then
#Requires:   mingw32-cross-nsis
# GTK3 theming
Requires:       adwaita-icon-theme

%_mingw32_package_header_debug
BuildArch:      noarch

%description
Viking is a free/open source program to manage GPS data.
You can import, plot and create tracks, routes and waypoints, show OSM and other maps, see real-time GPS position, control items, etc.
Other advanced capabilities include Geotagging Images, generate Maps (using Mapnik), Upload and Download tracks from OSM, Routing from OSRM, Name Searches from OSM Nominatim or Geonames and more.
It is written in mainly in C with some C++ and uses the GTK+3 toolkit.

%_mingw32_debug_package

%prep
%setup -q -n %{_pkg_name}-%{version}

%build
# Create Icon
pushd windows/installer/pixmaps
%{_mingw32_windres} viking_icon.rc -o viking_icon.o
popd

#
# Specifics for Windows build - i.e. no Mapnik yet
%{_mingw32_configure}\
  --disable-mapnik \
  --disable-geoclue \
  --enable-windows \
  CFLAGS="-DWINDOWS -DWIN32 -mwindows -DCURL_NO_SSL_VERIFYPEER"

%{_mingw32_make} %{?_smp_mflags}

%install
pushd src
%{_mingw32_strip} -g %{_pkg_name}.exe
popd

%make_install

%find_lang %{_pkg_name}

%files -f %{_pkg_name}.lang
%defattr(-,root,root)
%doc AUTHORS ChangeLog COPYING NEWS README.md doc/examples/*xml
%{_mingw32_bindir}/*%{_pkg_name}.exe
%{_mingw32_datadir}/%{_pkg_name}
%dir %{_mingw32_datadir}/applications
%{_mingw32_datadir}/applications/%{_pkg_name}.desktop
%dir %{_mingw32_datadir}/icons
%dir %{_mingw32_datadir}/icons/hicolor
%dir %{_mingw32_datadir}/icons/hicolor/48x48
%dir %{_mingw32_datadir}/icons/hicolor/48x48/apps
%{_mingw32_datadir}/icons/hicolor/48x48/apps/%{_pkg_name}.*
# Not generated anymore
#%%exclude %%{_mingw32_datadir}/icons/hicolor/icon-theme.cache

%changelog
