set(program_name doxygen)
set(program_version 1.9.8)
string(REPLACE "." "_" program_version_dir "Release_${program_version}")
if(CMAKE_HOST_WIN32)
    set(download_filename "doxygen-${program_version}.windows.x64.bin.zip")
    set(download_urls "https://github.com/doxygen/doxygen/releases/download/${program_version_dir}/${download_filename}")
    set(download_sha512 81203467e8ef746467a429c7b75b561e8c37c878020a09deb9363182d177363ea6116b6a8fa9e7304a63e99cf32c7f4ba3da2da8cd4171ce48180838439d6999)
    set(tool_subdirectory "v${program_version}")
elseif(VCPKG_HOST_IS_LINUX)
    execute_process(COMMAND uname -m OUTPUT_VARIABLE HOST_ARCH OUTPUT_STRIP_TRAILING_WHITESPACE)
    if(HOST_ARCH MATCHES "x86_64|amd64")
        set(download_filename "doxygen-${program_version}.linux.bin.tar.gz")
        set(download_urls "https://github.com/doxygen/doxygen/releases/download/${program_version_dir}/${download_filename}")
        set(download_sha512 344fee325679836dc242b838f5e92c0ff244f0571d1ecec121b58e788726a7e5f07c56f45c8c517696ac5d5e2d36f55a3a45a353151aa7b282eda8653462f8bb)
        set(paths_to_search "${DOWNLOADS}/tools/doxygen/doxygen-${program_version}/bin")
    endif()
endif()
