/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.Objects;

public final class Pair<A, B> {
    public A a;
    public B b;

    public Pair(A a, B b) {
        this.a = a;
        this.b = b;
    }

    public int hashCode() {
        return Objects.hash(this.a, this.b);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Pair pair = (Pair)other;
        return Objects.equals(this.a, pair.a) && Objects.equals(this.b, pair.b);
    }

    public static <T> Pair<T, T> sort(Pair<T, T> p) {
        if (p.b.hashCode() < p.a.hashCode()) {
            Object tmp = p.a;
            p.a = p.b;
            p.b = tmp;
        }
        return p;
    }

    public String toString() {
        return "<" + String.valueOf(this.a) + "," + String.valueOf(this.b) + ">";
    }

    public static <U, V> Pair<U, V> create(U u, V v) {
        return new Pair<U, V>(u, v);
    }
}

