/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.util.Comparator;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class NoteSortDialog
extends ExtendedDialog {
    private final JRadioButton defaultSort = new JRadioButton(I18n.tr("Default (open, closed, new)", new Object[0]));
    private final JRadioButton userSort = new JRadioButton(I18n.tr("Username", new Object[0]));
    private final JRadioButton dateSort = new JRadioButton(I18n.tr("Created date", new Object[0]));
    private final JRadioButton lastActionSort = new JRadioButton(I18n.tr("Last change date", new Object[0]));

    public NoteSortDialog(Component parent, String title, String buttonText) {
        super(parent, title, buttonText, I18n.tr("Cancel", new Object[0]));
    }

    public void showSortDialog(Comparator<Note> currentSortMode) {
        JLabel label = new JLabel(I18n.tr("Select note sorting method", new Object[0]));
        if (currentSortMode == Note.DEFAULT_COMPARATOR) {
            this.defaultSort.setSelected(true);
        } else if (currentSortMode == Note.DATE_COMPARATOR) {
            this.dateSort.setSelected(true);
        } else if (currentSortMode == Note.USER_COMPARATOR) {
            this.userSort.setSelected(true);
        } else if (currentSortMode == Note.LAST_ACTION_COMPARATOR) {
            this.lastActionSort.setSelected(true);
        } else {
            Logging.warn("sort mode not recognized");
        }
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.defaultSort);
        bg.add(this.userSort);
        bg.add(this.dateSort);
        bg.add(this.lastActionSort);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(label);
        panel.add(this.defaultSort);
        panel.add(this.userSort);
        panel.add(this.dateSort);
        panel.add(this.lastActionSort);
        this.setContent(panel);
        this.showDialog();
    }

    public Comparator<Note> getSelectedComparator() {
        if (this.dateSort.isSelected()) {
            return Note.DATE_COMPARATOR;
        }
        if (this.userSort.isSelected()) {
            return Note.USER_COMPARATOR;
        }
        if (this.lastActionSort.isSelected()) {
            return Note.LAST_ACTION_COMPARATOR;
        }
        return Note.DEFAULT_COMPARATOR;
    }
}

