/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Command;
import org.basex.core.Databases;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.cmd.DropDB;
import org.basex.core.locks.Locks;
import org.basex.core.users.Perm;
import org.basex.io.IOFile;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class Copy
extends Command {
    private int of;
    private int tf;

    public Copy(String db, String newdb) {
        super(Perm.CREATE, db, newdb);
    }

    @Override
    protected boolean run() {
        String src = this.args[0];
        String trg = this.args[1];
        if (!Databases.validName(src)) {
            return this.error(Text.NAME_INVALID_X, src);
        }
        if (!Databases.validName(trg)) {
            return this.error(Text.NAME_INVALID_X, trg);
        }
        if (!this.soptions.dbExists(src)) {
            return this.error(Text.DB_NOT_FOUND_X, src);
        }
        try {
            Copy.copy(src, trg, this.soptions, this);
            return this.info(Text.DB_COPIED_X, src, this.jc().performance);
        }
        catch (IOException ex) {
            Util.debug(ex);
            return this.error(Text.DB_NOT_COPIED_X, src);
        }
    }

    public static void copy(String source, String target, StaticOptions sopts, Copy cmd) throws IOException {
        DropDB.drop(target, sopts);
        IOFile src = sopts.dbPath(source);
        IOFile trg = sopts.dbPath(target);
        StringList files = src.descendants();
        if (cmd != null) {
            cmd.tf = files.size();
        }
        try {
            for (String file : files) {
                new IOFile(src, file).copyTo(new IOFile(trg, file));
                if (cmd == null) continue;
                ++cmd.of;
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            DropDB.drop(target, sopts);
            throw ex;
        }
    }

    @Override
    public void addLocks() {
        Locks locks = this.jc().locks;
        locks.reads.add(this.args[0]);
        locks.writes.add(this.args[1]);
    }

    @Override
    public String shortInfo() {
        return Text.COPY + "...";
    }

    @Override
    public boolean supportsProg() {
        return true;
    }

    @Override
    public double progressInfo() {
        return (double)this.of / (double)this.tf;
    }
}

