/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.index.query.StringRange;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpOp;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.expr.index.StringRangeAccess;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.index.IndexInfo;
import org.basex.query.value.Value;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.IntObjectMap;

public final class CmpSR
extends Single {
    final byte[] min;
    final boolean mni;
    final byte[] max;
    final boolean mxi;
    private boolean single;

    CmpSR(Expr expr, byte[] min, boolean mni, byte[] max, boolean mxi, InputInfo info) {
        super(info, expr, Types.BOOLEAN_O);
        this.min = min;
        this.mni = mni;
        this.max = max;
        this.mxi = mxi;
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.expr = this.expr.simplifyFor(CompileContext.Simplify.STRING, cc);
        SeqType st = this.expr.seqType();
        this.single = st.zeroOrOne() && !st.mayBeArray();
        return this.expr instanceof Value ? cc.preEval(this) : this;
    }

    static Expr get(CompileContext cc, CmpG cmp) throws QueryException {
        Expr cmp1 = cmp.exprs[0];
        Expr cmp2 = cmp.exprs[1];
        if (cmp1.has(Flag.NDT) || !(cmp2 instanceof AStr)) {
            return cmp;
        }
        AStr str2 = (AStr)cmp2;
        byte[] d = str2.string(cmp.info);
        CmpSR expr = switch (cmp.op) {
            case CmpOp.GE -> new CmpSR(cmp1, d, true, null, true, cmp.info);
            case CmpOp.GT -> new CmpSR(cmp1, d, false, null, true, cmp.info);
            case CmpOp.LE -> new CmpSR(cmp1, null, true, d, true, cmp.info);
            case CmpOp.LT -> new CmpSR(cmp1, null, true, d, false, cmp.info);
            default -> null;
        };
        return expr != null ? ((Expr)expr).optimize(cc) : cmp;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        return Bln.get(this.test(qc, ii, 0L));
    }

    @Override
    public boolean test(QueryContext qc, InputInfo ii, long pos) throws QueryException {
        Item item;
        if (this.single) {
            Item item2 = this.expr.item(qc, this.info);
            return item2 != Empty.VALUE && this.eval(item2);
        }
        Iter iter = this.expr.atomIter(qc, this.info);
        while ((item = qc.next(iter)) != null) {
            if (!this.eval(item)) continue;
            return true;
        }
        return false;
    }

    private boolean eval(Item item) throws QueryException {
        int mx;
        if (!item.type.isStringOrUntyped()) {
            throw QueryError.compareError(item, Str.EMPTY, this.info);
        }
        byte[] s = item.string(this.info);
        Collation coll = this.sc().collation;
        int mn = this.min == null ? 1 : Token.compare(s, this.min, coll);
        int n = mx = this.max == null ? -1 : Token.compare(s, this.max, coll);
        return (this.mni ? mn >= 0 : mn > 0) && (this.mxi ? mx <= 0 : mx < 0);
    }

    @Override
    public Expr mergeEbv(Expr ex, boolean or, CompileContext cc) throws QueryException {
        Collation coll = null;
        byte[] newMin = null;
        byte[] newMax = null;
        boolean newMni = true;
        boolean newMxi = true;
        if (ex instanceof CmpSR) {
            CmpSR cmp = (CmpSR)ex;
            newMin = cmp.min;
            newMax = cmp.max;
            newMni = cmp.mni;
            newMxi = cmp.mxi;
            coll = cmp.sc().collation;
        } else if (ex instanceof CmpG) {
            Expr expr;
            CmpG cmp = (CmpG)ex;
            if (cmp.op == CmpOp.EQ && (expr = cmp.exprs[1]) instanceof Str) {
                Str str = (Str)expr;
                newMin = str.string();
                newMax = newMin;
                coll = cmp.sc().collation;
            }
        }
        if (newMin == null && newMax == null || !this.expr.equals(ex.arg(0)) || coll != null || this.sc().collation != null || or) {
            return null;
        }
        if (newMin == null) {
            newMin = this.min;
            newMni = this.mni;
        } else if (this.min != null) {
            boolean bl = newMni = Token.eq(this.min, newMin = Token.max(this.min, newMin)) ? this.mni : newMni;
        }
        if (newMax == null) {
            newMax = this.max;
            newMxi = this.mxi;
        } else if (this.max != null) {
            boolean bl = newMxi = Token.eq(this.max, newMax = Token.min(this.max, newMax)) ? this.mxi : newMxi;
        }
        if (newMin != null && newMax != null) {
            int diff = Token.compare(newMin, newMax);
            if (diff == 0 && newMni && newMxi) {
                return new CmpG(this.info, this.expr, (Expr)Str.get(newMin), CmpOp.EQ).optimize(cc);
            }
            if (diff >= 0) {
                return Bln.FALSE;
            }
        }
        return new CmpSR(this.expr, newMin, newMni, newMax, newMxi, this.info).optimize(cc);
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) throws QueryException {
        if (this.sc().collation != null || this.min == null || this.max == null) {
            return false;
        }
        Data data = ii.db.data();
        if (data == null ? !ii.enforce() : data.inMemory()) {
            return false;
        }
        IndexType type = ii.type(this.expr, null);
        if (type == null) {
            return false;
        }
        StringRange sr = new StringRange(type, this.min, this.mni, this.max, this.mxi);
        ii.costs = IndexInfo.costs(data, sr);
        if (ii.costs == null) {
            return false;
        }
        TokenBuilder tb = new TokenBuilder();
        tb.add(this.mni ? 91 : 40).add(this.min).add(44).add(this.max).add(this.mxi ? 93 : 41);
        ii.create(new StringRangeAccess(this.info, sr, ii.db), true, Util.info("apply % index for %", String.valueOf((Object)type) + " string range", tb), this.info);
        return true;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        CmpSR cmp = new CmpSR(this.expr.copy(cc, vm), this.min, this.mni, this.max, this.mxi, this.info);
        cmp.single = this.single;
        return this.copyType(cmp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof CmpSR)) return false;
        CmpSR cmp = (CmpSR)obj;
        if (!Token.eq(this.min, cmp.min)) return false;
        if (this.mni != cmp.mni) return false;
        if (!Token.eq(this.max, cmp.max)) return false;
        if (!this.mxi) return false;
        if (!cmp.mxi) return false;
        if (this.sc() != cmp.sc()) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public String description() {
        return "string range comparison";
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "min", this.min, "max", this.max, "include-min", this.mni, "include-max", this.mxi, "single", this.single), this.expr);
    }

    @Override
    public void toString(QueryString qs) {
        if (this.min != null) {
            qs.token(this.expr).token(this.mni ? ">= " : "> ").quoted(this.min);
        }
        if (this.min != null && this.max != null) {
            qs.token("and");
        }
        if (this.max != null) {
            qs.token(this.expr).token(this.mxi ? "<= " : "< ").quoted(this.max);
        }
    }
}

