/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.expr.TypeCheck;
import org.basex.query.func.fn.FnError;
import org.basex.query.util.DeepEqual;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Types;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class SwitchGroup
extends Arr {
    private final DeepEqual deep;

    public SwitchGroup(InputInfo info, Expr ... exprs) {
        super(info, Types.ITEM_ZM, exprs);
        this.deep = new DeepEqual(info);
    }

    @Override
    public void checkUp() throws QueryException {
        int el = this.exprs.length;
        for (int e = 1; e < el; ++e) {
            this.checkNoUp(this.exprs[e]);
        }
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        for (int e = 0; e < el; ++e) {
            this.exprs[e] = cc.compileOrError(this.exprs[e], false);
        }
        return this.optimize(cc);
    }

    @Override
    public SwitchGroup optimize(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        for (int e = 1; e < el; ++e) {
            this.exprs[e] = this.exprs[e].simplifyFor(CompileContext.Simplify.STRING, cc);
        }
        return (SwitchGroup)this.adoptType(this.rtrn());
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new SwitchGroup(this.info, SwitchGroup.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        return ic.inline(this.exprs, true) ? this.optimize(ic.cc) : null;
    }

    @Override
    public Expr typeCheck(TypeCheck tc, CompileContext cc) throws QueryException {
        Expr rtrn = this.rtrn();
        try {
            rtrn = tc.check(rtrn, cc);
        }
        catch (QueryException ex) {
            rtrn = FnError.get(ex, rtrn);
        }
        if (rtrn == null) {
            return null;
        }
        this.exprs[0] = rtrn;
        return this.optimize(cc);
    }

    @Override
    public VarUsage count(Var var) {
        return this.rtrn().count(var);
    }

    VarUsage countCases(Var var) {
        VarUsage uses = VarUsage.NEVER;
        int el = this.exprs.length;
        for (int e = 1; e < el && (uses = uses.plus(this.exprs[e].count(var))) != VarUsage.MORE_THAN_ONCE; ++e) {
        }
        return uses;
    }

    boolean match(Item cond, QueryContext qc) throws QueryException {
        int el = this.exprs.length;
        for (int e = 1; e < el; ++e) {
            if (!this.match(cond, e, qc)) continue;
            return true;
        }
        return el == 1;
    }

    boolean match(Item cond, int e, QueryContext qc) throws QueryException {
        Value value = this.exprs[e].atomValue(qc, this.info);
        if (cond == Empty.VALUE) {
            return cond == value;
        }
        for (Item item : value) {
            if (!this.deep.equal(cond, item)) continue;
            return true;
        }
        return false;
    }

    Expr rtrn() {
        return this.exprs[0];
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr rtrn = this.rtrn();
        this.exprs[0] = rtrn.simplifyFor(mode, cc);
        return rtrn != this.exprs[0] ? null : this;
    }

    @Override
    public void markTailCalls(CompileContext cc) {
        this.rtrn().markTailCalls(cc);
    }

    @Override
    public int exprSize() {
        int size = 0;
        for (Expr expr : this.exprs) {
            size += expr.exprSize();
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof SwitchGroup && super.equals(obj);
    }

    @Override
    public void toString(QueryString qs) {
        int el = this.exprs.length;
        for (int e = 1; e < el; ++e) {
            qs.token("case").token(this.exprs[e]);
        }
        if (el == 1) {
            qs.token("default");
        }
        qs.token("return").token(this.rtrn());
    }
}

