/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.value.Value;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjectMap;

public final class Treat
extends Single {
    public Treat(InputInfo info, Expr expr, SeqType seqType) {
        super(info, expr, seqType);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        SeqType st = this.seqType();
        SeqType et = this.expr.seqType();
        if (et.instanceOf(st)) {
            cc.info("remove % type check: %", st, this.expr);
            return this.expr;
        }
        return this.expr instanceof Value ? cc.preEval(this) : this;
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Value value = this.expr.value(qc);
        SeqType st = this.seqType();
        if (st.instance(value)) {
            return value;
        }
        throw QueryError.NOTREAT_X_X_X.get(this.info, this.expr.seqType(), st, this.expr);
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new Treat(this.info, this.expr.copy(cc, vm), this.seqType()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Treat)) return false;
        Treat trt = (Treat)obj;
        if (!this.seqType().eq(trt.seqType())) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "as", this.seqType()), this.expr);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("(").token(this.expr).token("treat").token("as").token(this.seqType()).token(')');
    }
}

