/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.bin;

import java.math.BigInteger;
import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.util.Array;
import org.basex.util.InputInfo;

public final class BinShift
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        byte[] shifted;
        Bin value = this.toBinOrNull(this.arg(0), qc);
        long by = this.toLong(this.arg(1), qc);
        if (value == null) {
            return Empty.VALUE;
        }
        if (by == 0L) {
            return value;
        }
        byte[] bytes = value.binary(this.info);
        int bl = bytes.length;
        if (bl == 1) {
            byte b = bytes[0];
            return B64.get((byte)(by > 0L ? b << (int)by : (b & 0xFF) >> (int)(-by)));
        }
        if (by / 8L >= (long)bl || by / 8L <= (long)(-bl)) {
            shifted = new byte[bl];
        } else {
            int shifts = (int)(by < 0L ? -by : by);
            BigInteger bi = new BigInteger(bytes);
            if (by > 0L) {
                bi = bi.shiftLeft(shifts);
            } else if (bi.signum() >= 0) {
                bi = bi.shiftRight(shifts);
            } else {
                BigInteger o = BigInteger.ONE.shiftLeft((bl << 3) + 1);
                BigInteger m = o.subtract(BigInteger.ONE).shiftRight(shifts + 1);
                bi = bi.subtract(o).shiftRight(shifts).and(m);
            }
            shifted = bi.toByteArray();
        }
        int tl = shifted.length;
        if (tl < bl) {
            byte[] tmp = new byte[bl];
            Array.copyFromStart(shifted, tl, tmp, bl - tl);
            shifted = tmp;
        } else if (tl > bl) {
            shifted = Arrays.copyOfRange(shifted, tl - bl, tl);
        }
        return B64.get(shifted);
    }
}

