/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import java.util.HashMap;
import java.util.Locale;
import org.basex.core.MainOptions;
import org.basex.data.Data;
import org.basex.index.resource.ResourceType;
import org.basex.index.resource.Resources;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.db.DbAccessFn;
import org.basex.query.up.primitives.NewInput;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.list.IntList;

abstract class DbNew
extends DbAccessFn {
    DbNew() {
    }

    final NewInput toNewInput(Item input, String path) throws QueryException {
        NewInput ni = new NewInput();
        if (input instanceof ANode) {
            ANode node = (ANode)input;
            if (Strings.endsWith(path, '/')) {
                throw QueryError.DB_PATH_X.get(this.info, path);
            }
            String name = path;
            if (name.isEmpty()) {
                int i;
                name = Token.string(node.baseURI());
                Data data = node.data();
                int n = i = data == null || data.inMemory() ? name.lastIndexOf(47) : name.indexOf(47);
                if (i != -1) {
                    name = name.substring(i + 1);
                }
                if (name.isEmpty()) {
                    throw QueryError.DB_PATH_X.get(this.info, name);
                }
            }
            if (node.type == NodeType.ATTRIBUTE) {
                throw QueryError.UPDOCTYPE_X.get(this.info, node);
            }
            ni.node = node;
            ni.path = name;
            return ni;
        }
        if (!input.type.isStringOrUntyped()) {
            throw QueryError.STRNOD_X_X.get(this.info, input.type, input);
        }
        String string = Token.string(input.string(this.info));
        IO io = IO.get(string);
        if (!io.exists()) {
            throw QueryError.WHICHRES_X.get(this.info, string);
        }
        Object name = path;
        if (!Strings.endsWith((String)name, '/') && (io.isDir() || io.isArchive())) {
            name = (String)name + "/";
        }
        String target = "";
        int s = ((String)name).lastIndexOf(47);
        if (s != -1) {
            target = ((String)name).substring(0, s);
            name = ((String)name).substring(s + 1);
        }
        if (!((String)name).isEmpty()) {
            io.name((String)name);
        } else if (!(io instanceof IOContent)) {
            name = io.name();
        }
        if (((String)name).isEmpty()) {
            throw QueryError.DB_PATH_X.get(this.info, path);
        }
        ni.io = io;
        ni.path = target;
        return ni;
    }

    final boolean put(IntList docs, Data data, String path, HashMap<String, String> options) {
        String pr = options.get(MainOptions.REPLACE.name().toLowerCase(Locale.ENGLISH));
        if (pr == null || Strings.toBoolean(pr).booleanValue()) {
            return true;
        }
        boolean add = docs.isEmpty();
        for (ResourceType type : Resources.BINARIES) {
            IOFile bin = data.meta.file(path, type);
            add &= bin == null || !bin.exists();
        }
        return add;
    }
}

