/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.func.Functions;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.StaticFunc;
import org.basex.query.scope.AModule;
import org.basex.query.scope.ContextScope;
import org.basex.query.util.hash.QNmMap;
import org.basex.query.util.parse.FuncBuilder;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.item.QNm;
import org.basex.query.value.map.MapBuilder;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.Types;
import org.basex.query.var.StaticVar;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;
import org.basex.util.options.StringsOption;
import org.basex.util.options.ValueOption;

public final class FnLoadXQueryModule
extends StandardFunc {
    private static final MapType QNAME_MAP_TYPE = MapType.get(AtomType.QNAME, Types.ITEM_ZM);

    @Override
    public XQMap item(QueryContext qc, InputInfo ii) throws QueryException {
        byte[] modUri = this.toToken(this.arg(0).atomItem(qc, this.info));
        if (modUri.length == 0) {
            throw QueryError.MODULE_URI_EMPTY.get(this.info, new Object[0]);
        }
        XQMap options = this.toEmptyMap(this.arg(1), qc);
        LoadXQueryModuleOptions opt = this.toOptions(options, new LoadXQueryModuleOptions(), qc);
        String[] hints = opt.get(LoadXQueryModuleOptions.LOCATION_HINTS);
        Map<String, XQMap> modCache = null;
        String cacheKey = null;
        if (hints.length == 1 && options.structSize() == 1L) {
            QueryContext qcAnc = qc;
            while (qcAnc.parent != null) {
                qcAnc = qcAnc.parent;
            }
            modCache = qcAnc.threads.moduleCache().get();
            if (modCache.containsKey(cacheKey = new TokenBuilder(modUri).add(35).add(hints[0]).toString())) {
                return modCache.get(cacheKey);
            }
        }
        ArrayList<IO> srcs = new ArrayList<IO>();
        String cont = opt.get(LoadXQueryModuleOptions.CONTENT);
        if (cont != null) {
            srcs.add(new IOContent(cont));
        } else {
            StringList locs = (StringList)new StringList().add(hints);
            if (locs.isEmpty()) {
                TokenList files = qc.modDeclared.get(modUri);
                if (files != null) {
                    Iterator iterator = files.iterator();
                    while (iterator.hasNext()) {
                        byte[] file = (byte[])iterator.next();
                        locs.add(Token.string(file));
                    }
                } else {
                    String path = FnLoadXQueryModule.repoFilePath(modUri, qc.context);
                    if (path != null) {
                        locs.add(path);
                    }
                }
            }
            if (locs.isEmpty()) {
                throw QueryError.MODULE_NOT_FOUND_X.get(this.info, new Object[]{modUri});
            }
            for (Object loc : locs) {
                srcs.add(ii.sc().resolve((String)loc, ii.path()));
            }
        }
        QNmMap<Value> bindings = new QNmMap<Value>();
        if (opt.contains(LoadXQueryModuleOptions.VARIABLES)) {
            XQMap vars = ((XQMap)opt.get(LoadXQueryModuleOptions.VARIABLES)).coerceTo(QNAME_MAP_TYPE, qc, null, ii);
            vars.forEach((key, value) -> bindings.put((QNm)key, (Value)value));
        }
        if (opt.contains(LoadXQueryModuleOptions.VENDOR_OPTIONS)) {
            ((XQMap)opt.get(LoadXQueryModuleOptions.VENDOR_OPTIONS)).coerceTo(QNAME_MAP_TYPE, qc, null, ii);
        }
        if (opt.contains(LoadXQueryModuleOptions.XQUERY_VERSION)) {
            Object version = opt.get(LoadXQueryModuleOptions.XQUERY_VERSION).toString();
            if (!((String)version).contains(".")) {
                version = (String)version + ".0";
            }
            if (!QueryContext.isSupported((String)version)) {
                throw QueryError.MODULE_XQUERY_VERSION_X.get(this.info, version);
            }
        }
        QueryContext mqc = new QueryContext(qc);
        for (byte[] uri : qc.modDeclared) {
            mqc.modDeclared.put(uri, qc.modDeclared.get(uri));
        }
        int nParsed = 0;
        Value ctx = opt.get(LoadXQueryModuleOptions.CONTEXT_ITEM);
        if (ctx != null) {
            mqc.contextValue = new ContextScope(ctx, mqc.contextType, new VarScope(), this.sc(), null, null);
            mqc.finalContext = true;
        }
        for (IO iO : srcs) {
            AModule lib;
            try {
                String path = iO.path();
                String content = iO.readString();
                String uri = path.isEmpty() ? Token.string(this.sc().baseURI().string()) : path;
                lib = mqc.parse(content, uri);
            }
            catch (IOException ex) {
                Util.debug(ex);
                throw QueryError.WHICHMODFILE_X.get(this.info, iO);
            }
            catch (QueryException ex) {
                Util.debug(ex);
                throw QueryError.MODULE_STATIC_ERROR_X_X.get(this.info, modUri, ex.getLocalizedMessage());
            }
            try {
                mqc.vars.bindExternal(mqc, bindings, false);
            }
            catch (QueryException ex) {
                Util.debug(ex);
                throw ex.error() != QueryError.INVTYPE_X ? ex : QueryError.MODULE_PARAMETER_TYPE_X_X.get(this.info, modUri, ex.getLocalizedMessage());
            }
            if (ctx != null && lib.sc.contextType != null && !lib.sc.contextType.instance(ctx)) {
                throw QueryError.MODULE_CONTEXT_TYPE_X_X.get(this.info, modUri, ctx.seqType());
            }
            mqc.compile(true);
            if (mqc.main != null) {
                throw QueryError.MODULE_FOUND_MAIN_X.get(this.info, new Object[]{modUri});
            }
            Iterator<byte[]> it = mqc.modParsed.values().iterator();
            for (int i = 0; i < nParsed; ++i) {
                it.next();
            }
            byte[] uri = it.next();
            if (!Token.eq(modUri, uri)) {
                String path = iO.path();
                throw path.isEmpty() ? QueryError.MODULE_FOUND_OTHER_X.get(this.info, new Object[]{modUri}) : QueryError.MODULE_FOUND_OTHER_X_X.get(this.info, modUri, path);
            }
            nParsed = mqc.modParsed.size();
        }
        QNmMap<Map> funcs = new QNmMap<Map>();
        for (Object sf : mqc.functions) {
            if (((StaticFunc)sf).updating()) {
                mqc.updating();
            }
            if (((StaticFunc)sf).anns.contains(Annotation.PRIVATE) || !Token.eq(((StaticFunc)sf).name.uri(), modUri)) continue;
            for (int a = ((StaticFunc)sf).minArity(); a <= ((StaticFunc)sf).arity(); ++a) {
                FuncBuilder fb = new FuncBuilder(((StaticFunc)sf).info, a, true);
                Expr item = Functions.item((StaticFunc)sf, fb, mqc);
                funcs.computeIfAbsent(((StaticFunc)sf).name, HashMap::new).put(a, item);
            }
        }
        MapBuilder mapBuilder = new MapBuilder();
        for (QNm qnm : funcs) {
            MapBuilder arities = new MapBuilder();
            Map funcItems = (Map)funcs.get(qnm);
            for (Map.Entry entry : funcItems.entrySet()) {
                arities.put((Item)Itr.get(((Integer)entry.getKey()).intValue()), ((Expr)entry.getValue()).value(mqc));
            }
            mapBuilder.put((Item)qnm, (Value)arities.map());
        }
        MapBuilder variables = new MapBuilder();
        for (StaticVar var : mqc.vars) {
            if (var.anns.contains(Annotation.PRIVATE) || !Token.eq(var.name.uri(), modUri)) continue;
            variables.put((Item)var.name, var.value(mqc));
        }
        MapBuilder result = new MapBuilder();
        result.put("variables", (Value)variables.map());
        result.put("functions", (Value)mapBuilder.map());
        XQMap map = result.map();
        if (modCache != null) {
            modCache.put(cacheKey, map);
        }
        return map;
    }

    private static String repoFilePath(byte[] modUri, Context context) {
        String path = Strings.uri2path(Token.string(modUri));
        String repoPath = context.soptions.get(StaticOptions.REPOPATH);
        for (String suffix : IO.XQSUFFIXES) {
            IOFile file = new IOFile(repoPath, path + suffix);
            if (!file.exists()) continue;
            return file.path();
        }
        return null;
    }

    public static final class LoadXQueryModuleOptions
    extends Options {
        public static final ValueOption XQUERY_VERSION = new ValueOption("xquery-version", Types.DECIMAL_O, null);
        public static final StringsOption LOCATION_HINTS = new StringsOption("location-hints", new String[0]);
        public static final StringOption CONTENT = new StringOption("content");
        public static final ValueOption CONTEXT_ITEM = new ValueOption("context-item", Types.ITEM_ZO, null);
        public static final ValueOption VARIABLES = new ValueOption("variables", Types.MAP_O, null);
        public static final ValueOption VENDOR_OPTIONS = new ValueOption("vendor-options", Types.MAP_O, null);
    }
}

