/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.io.IOException;
import java.io.InputStream;
import org.basex.core.CommonOptions;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.DecodingException;
import org.basex.io.in.InputException;
import org.basex.io.in.NewlineInput;
import org.basex.io.in.TextInput;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.util.Util;
import org.basex.util.options.Options;

public abstract class ParseFn
extends StandardFunc {
    IO input;

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        return this.optFirst();
    }

    boolean nl() {
        return false;
    }

    QueryError error() {
        return null;
    }

    protected abstract Options options(QueryContext var1) throws QueryException;

    protected Value parse(QueryContext qc) throws QueryException {
        Value value;
        block10: {
            Item value2 = this.arg(0).atomItem(qc, this.info);
            if (value2.isEmpty()) {
                return Empty.VALUE;
            }
            IOContent io = new IOContent(this.toBytes(value2));
            TextInput ti = this.nl() ? new NewlineInput(io) : new TextInput(io);
            try {
                value = this.parse(ti.validate(true), this.options(qc), qc);
                if (ti == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ti != null) {
                        try {
                            ti.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DecodingException ex) {
                    throw QueryError.RECDECODING_X.get(this.info, ex);
                }
                catch (IOException ex) {
                    throw this.error().get(this.info, ex);
                }
            }
            ti.close();
        }
        return value;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Value doc(QueryContext qc) throws QueryException {
        String source = this.toStringOrNull(this.arg(0), qc);
        if (source == null) {
            return Empty.VALUE;
        }
        String[] testResources = qc.resources.text(source, this.sc());
        IO io = testResources != null ? IO.get(testResources[0]) : (this.input != null ? this.input : this.toIO(source, false));
        Options options = this.options(qc);
        String enc = this.toEncodingOrNull(options.get(CommonOptions.ENCODING), QueryError.RESENCODING_X);
        String encoding = enc != null ? enc : (testResources != null ? testResources[1] : null);
        Boolean normalize = options.get(CommonOptions.NORMALIZE_NEWLINES);
        if (normalize != null) {
            if (this.nl()) {
                throw QueryError.INVALIDOPTION_X.get(this.info, Options.unknown(CommonOptions.NORMALIZE_NEWLINES));
            }
        } else {
            normalize = this.nl();
        }
        try (InputStream is = io.inputStream();){
            Value value;
            block20: {
                TextInput ti = normalize != false ? new NewlineInput(io, encoding) : new TextInput(io, encoding);
                try {
                    value = this.parse(ti.validate(true), options, qc);
                    if (ti == null) break block20;
                }
                catch (Throwable throwable) {
                    if (ti != null) {
                        try {
                            ti.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ti.close();
            }
            return value;
        }
        catch (DecodingException ex) {
            throw QueryError.RECDECODING_X.get(this.info, ex);
        }
        catch (InputException ex) {
            throw this.error().get(this.info, ex);
        }
        catch (IOException ex) {
            Util.debug(ex);
            throw QueryError.RESWHICH_X.get(this.info, io);
        }
    }

    abstract Value parse(TextInput var1, Options var2, QueryContext var3) throws QueryException, IOException;
}

