/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.format;

import org.basex.query.util.format.FormatParser;
import org.basex.query.util.format.Formatter;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.TokenParser;

final class FormatterFR
extends Formatter {
    private static final byte[][] WORDS = Token.tokens("z\u00e9ro", "un", "deux", "trois", "quatre", "cinq", "six", "sept", "huit", "neuf", "dix", "onze", "douze", "treize", "quatorze", "quinze", "seize", "dix-sept", "dix-huit", "dix-neuf");
    private static final byte[][] WORDS20 = Token.tokens("", "", "vingt", "trente", "quarante", "cinquante", "soixante", "", "quatre-vingt");
    private static final byte[][] WORDS1000000 = Token.tokens("million", "milliard", "billion", "billiard", "trillion");
    private static final byte[] ORDINAL = Token.token("i\u00e8me");
    private static final long[] UNITS100 = new long[]{1000000L, 1000000000L, 1000000000000L, 1000000000000000L, 1000000000000000000L};
    private static final byte[][] DAYS = Token.tokens("Lundi", "Mardi", "Mercredi", "Jeudi", "Vendredi", "Samedi", "Dimanche");
    private static final byte[][] MONTHS = Token.tokens("Janvier", "F\u00e9vrier", "Mars", "Avril", "Mai", "Juin", "Juillet", "Ao\u00fbt", "Septembre", "Octobre", "Novembre", "D\u00e9cembre");
    private static final byte[][] AMPM = Token.tokens("a.m.", "p.m.");
    private static final byte[][] ERAS = Token.tokens("av. J.-C.", "ap. J.-C.");

    FormatterFR() {
    }

    @Override
    public byte[] word(long n, FormatParser.NumeralType numType, byte[] modifier) {
        byte[] suffix = modifier == null || modifier[0] == 37 ? null : Token.delete(modifier, 45);
        TokenBuilder tb = new TokenBuilder();
        FormatterFR.word(tb, n, numType, suffix, true);
        TokenParser tp = new TokenParser(tb.next());
        boolean u = true;
        while (tp.more()) {
            tb.add(u ? Token.uc(tp.next()) : Token.lc(tp.next()));
            u = false;
        }
        return tb.finish();
    }

    @Override
    public byte[] suffix(long n, FormatParser.NumeralType numType) {
        return Token.EMPTY;
    }

    @Override
    public byte[] month(int n, int min, int max) {
        return FormatterFR.format(MONTHS[n], min, max);
    }

    @Override
    public byte[] day(int n, int min, int max) {
        return FormatterFR.format(DAYS[n], min, max);
    }

    @Override
    public byte[] ampm(boolean am) {
        return AMPM[am ? 0 : 1];
    }

    @Override
    public byte[] calendar() {
        return ERAS[1];
    }

    @Override
    public byte[] era(long year) {
        return ERAS[year <= 0L ? 0 : 1];
    }

    private static void word(TokenBuilder tb, long n, FormatParser.NumeralType numType, byte[] suffix, boolean last) {
        if (n == 0L && !tb.isEmpty()) {
            if (numType == FormatParser.NumeralType.ORDINAL) {
                tb.add(ORDINAL).add(suffix == null ? Token.EMPTY : suffix);
            }
        } else if (n < 20L) {
            if (numType != FormatParser.NumeralType.ORDINAL) {
                tb.add(WORDS[(int)n]);
            } else if (n == 1L) {
                tb.add(tb.isEmpty() ? "premier" : "uni\u00e8me");
            } else {
                FormatterFR.suffix(numType, suffix, tb.add(WORDS[(int)n]));
            }
        } else if (n < 60L) {
            int r = (int)(n % 10L);
            tb.add(WORDS20[(int)n / 10]);
            if (r == 1) {
                tb.add(" et un");
            } else if (r > 1) {
                tb.add(45).add(WORDS[r]);
            }
            FormatterFR.suffix(numType, suffix, tb);
        } else if (n < 80L) {
            tb.add(WORDS20[6]);
            int r = (int)(n % 20L);
            if (r == 1) {
                tb.add(" et un");
            } else if (r == 11) {
                tb.add(" et onze");
            } else if (r > 1) {
                tb.add(45).add(WORDS[r]);
            }
            FormatterFR.suffix(numType, suffix, tb);
        } else if (n < 100L) {
            tb.add(WORDS20[8]);
            int r = (int)(n % 20L);
            if (r > 0) {
                tb.add(45).add(WORDS[r]);
            } else if (numType != FormatParser.NumeralType.ORDINAL && last) {
                tb.add("s");
            }
            FormatterFR.suffix(numType, suffix, tb);
        } else if (n < 1000L) {
            if (n >= 200L) {
                FormatterFR.word(tb, n / 100L, FormatParser.NumeralType.NUMBERING, null, false);
                tb.add(32);
            }
            tb.add("cent");
            int r = (int)(n % 100L);
            if (r != 0) {
                tb.add(32);
            } else if (n > 100L && numType != FormatParser.NumeralType.ORDINAL && last) {
                tb.add(115);
            }
            if (r == 1 && numType == FormatParser.NumeralType.ORDINAL) {
                FormatterFR.suffix(numType, suffix, tb.add(WORDS[1]));
            } else {
                FormatterFR.word(tb, n % 100L, numType, suffix, last);
            }
        } else if (n < 1000000L) {
            if (n >= 2000L) {
                FormatterFR.word(tb, n / 1000L, FormatParser.NumeralType.NUMBERING, null, false);
                tb.add(32);
            }
            int r = (int)(n % 1000L);
            tb.add(numType == FormatParser.NumeralType.ORDINAL && r == 0 ? "mill" : "mille");
            if (r != 0) {
                tb.add(32);
            }
            FormatterFR.word(tb, n % 1000L, numType, suffix, last);
        } else {
            int w = WORDS1000000.length;
            while (--w > 0 && n < UNITS100[w]) {
            }
            long f = UNITS100[w];
            long i = n / f;
            if (i != 1L) {
                FormatterFR.word(tb, i, FormatParser.NumeralType.NUMBERING, null, true);
                tb.add(32);
            } else if (numType != FormatParser.NumeralType.ORDINAL) {
                tb.add("un ");
            }
            tb.add(WORDS1000000[w]);
            long r = n % f;
            if (numType == FormatParser.NumeralType.ORDINAL && r == 0L) {
                tb.add(ORDINAL).add(suffix == null ? Token.EMPTY : suffix);
            } else if (i > 1L && numType != FormatParser.NumeralType.ORDINAL) {
                tb.add("s");
            }
            if (r != 0L) {
                tb.add(32);
                FormatterFR.word(tb, r, numType, suffix, last);
            }
        }
    }

    private static void suffix(FormatParser.NumeralType numType, byte[] suffix, TokenBuilder tb) {
        if (numType == FormatParser.NumeralType.ORDINAL) {
            int l = tb.size() - 1;
            byte c = tb.get(l);
            if (c == 101) {
                tb.delete(l, l + 1);
            } else if (c == 102) {
                tb.set(l, (byte)118);
            } else if (c == 113) {
                tb.add(117);
            }
            tb.add(ORDINAL);
            if (suffix != null) {
                tb.add(suffix);
            }
        }
    }
}

