/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.TrieKeys;
import org.basex.util.Util;

final class TrieOrder {
    private TrieKeys added;
    private TrieKeys removed;

    TrieOrder(Item ... keys) {
        this(new TrieKeys(keys), null);
    }

    private TrieOrder(TrieKeys added, TrieKeys removed) {
        this.added = added;
        this.removed = removed;
    }

    Value keys() {
        this.optimize();
        return this.added.keys();
    }

    Item keyAt(int index) {
        this.optimize();
        return this.added.keyAt(index);
    }

    TrieOrder add(Item key) {
        return new TrieOrder(this.added.add(key), this.removed);
    }

    TrieOrder remove(Item key) {
        return new TrieOrder(this.added, this.removed != null ? this.removed.add(key) : new TrieKeys(key));
    }

    private void optimize() {
        if (this.removed != null) {
            this.added = this.added.remove(this.removed);
            this.removed = null;
        }
    }

    public String toString() {
        return Util.className(this) + "[Keys: " + String.valueOf(this.added) + (String)(this.removed != null ? "; removed: " + String.valueOf(this.removed) : "") + "]";
    }
}

