/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.util.Arrays;
import java.util.function.Predicate;
import org.basex.core.jobs.Job;
import org.basex.data.Data;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.ItemSeq;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public class DBNodeSeq
extends NativeSeq {
    protected final Data data;
    protected final boolean all;
    protected int[] pres;

    protected DBNodeSeq(int[] pres, Data data, Type type, boolean all) {
        super(pres.length, type);
        this.pres = pres;
        this.data = data;
        this.all = all;
    }

    @Override
    public final Data data() {
        return this.data;
    }

    @Override
    public final boolean ddo() {
        return true;
    }

    @Override
    public DBNode itemAt(long index) {
        return new DBNode(this.data, this.pres[(int)index]);
    }

    @Override
    public final Value atomValue(QueryContext qc, InputInfo ii) {
        ValueBuilder vb = new ValueBuilder(qc, this.size);
        int i = 0;
        while ((long)i < this.size) {
            vb.add(this.itemAt(i).atomValue(qc, ii));
            ++i;
        }
        return vb.value(AtomType.ANY_ATOMIC_TYPE);
    }

    public final int[] pres() {
        return this.pres;
    }

    public final int pre(int index) {
        return this.pres[index];
    }

    public final boolean all() {
        return this.all;
    }

    @Override
    public final Value reverse(Job job) {
        int sz = (int)this.size;
        int[] tmp = new int[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.pres[i];
        }
        return new DBNodeSeq(tmp, this.data, this.type, false);
    }

    @Override
    public final Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Value expr = this;
        if (mode.oneOf(CompileContext.Simplify.DATA, CompileContext.Simplify.NUMBER, CompileContext.Simplify.STRING)) {
            if (mode == CompileContext.Simplify.STRING) {
                TokenList list = new TokenList(this.size);
                int i = 0;
                while ((long)i < this.size) {
                    list.add(this.data.atom(this.pres[i]));
                    ++i;
                }
                expr = StrSeq.get(list);
            } else {
                int sz = (int)this.size;
                Item[] items = new Item[sz];
                int i = 0;
                while ((long)i < this.size) {
                    items[i] = Atm.get(this.data.atom(this.pres[i]));
                    ++i;
                }
                expr = ItemSeq.get(items, sz, AtomType.UNTYPED_ATOMIC);
            }
        }
        return cc.simplify(this, expr, mode);
    }

    @Override
    public final boolean materialized(Predicate<Data> test, InputInfo ii) {
        return test.test(this.data);
    }

    @Override
    public boolean refineType() {
        if (this.type == NodeType.NODE) {
            for (Item item : this) {
                if (item.type.eq(this.type)) continue;
                return false;
            }
            this.type = this.itemAt((long)0L).type;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj instanceof DBNodeSeq) {
            DBNodeSeq ds = (DBNodeSeq)obj;
            if (this.data != ds.data) return false;
            if (this.size != ds.size) return false;
            if (!Arrays.equals(this.pres, ds.pres)) return false;
            return true;
        } else if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public final void toString(QueryString qs) {
        TokenBuilder tb = new TokenBuilder().add(40);
        int p = 0;
        while ((long)p < this.size) {
            if (p > 0) {
                tb.add(", ");
            }
            tb.add(Function._DB_GET_PRE.args(this.data.meta.name, this.pres[p]).trim());
            if (tb.size() > 16 && (long)(p + 1) != this.size) {
                tb.add(", ").add("...");
                break;
            }
            ++p;
        }
        qs.token(tb.add(41).finish());
    }

    public static Value get(int[] pres, Data data, Type type, boolean all) {
        return pres.length == 0 ? Empty.VALUE : (pres.length == 1 ? new DBNode(data, pres[0]) : new DBNodeSeq(pres, data, type == null ? NodeType.NODE : type, all));
    }

    public static Value get(int[] pres, Data data, Expr expr) {
        return DBNodeSeq.get(pres, data, NodeType.NODE.refine(expr), false);
    }

    public static Value get(IntList pres, Data data, boolean docs, boolean all) {
        return DBNodeSeq.get(pres.toArray(), data, docs ? NodeType.DOCUMENT_NODE : null, all);
    }
}

