/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.io.IOException;
import org.basex.core.jobs.Job;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryContext;
import org.basex.query.value.Value;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class StrSeq
extends NativeSeq {
    private final byte[][] values;

    private StrSeq(byte[][] values, Type type) {
        super(values.length, type);
        this.values = values;
    }

    public static Value read(DataInput in, Type type, QueryContext qc) throws IOException {
        int size = in.readNum();
        byte[][] values = new byte[size][];
        for (int s = 0; s < size; ++s) {
            values[s] = in.readToken();
        }
        return StrSeq.get(values, type);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeNum((int)this.size);
        for (byte[] v : this.values) {
            out.writeToken(v);
        }
    }

    @Override
    public Item itemAt(long index) {
        return StrSeq.get(this.values[(int)index], this.type);
    }

    @Override
    public Value reverse(Job job) {
        int sz = (int)this.size;
        byte[][] array = new byte[sz][];
        for (int i = 0; i < sz; ++i) {
            array[sz - i - 1] = this.values[i];
        }
        return StrSeq.get(array, this.type);
    }

    public String[] toJava() {
        StringList sl = new StringList((int)this.size);
        for (byte[] value : this.values) {
            sl.add(value);
        }
        return (String[])sl.finish();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj instanceof StrSeq) {
            StrSeq seq = (StrSeq)obj;
            if (!Array.equals(this.values, seq.values)) return false;
            return true;
        } else if (!super.equals(obj)) return false;
        return true;
    }

    public static Value get(TokenList values) {
        return StrSeq.get(values, (Type)AtomType.STRING);
    }

    public static Value get(TokenList values, Type type) {
        return values.isEmpty() ? Empty.VALUE : (values.size() == 1 ? StrSeq.get((byte[])values.get(0), type) : new StrSeq((byte[][])values.finish(), type));
    }

    public static Value get(byte[][] values) {
        return StrSeq.get(values, (Type)AtomType.STRING);
    }

    public static Value get(byte[][] values, Type type) {
        int vl = values.length;
        return vl == 0 ? Empty.VALUE : (vl == 1 ? StrSeq.get(values[0], type) : new StrSeq(values, type));
    }

    private static Item get(byte[] string, Type type) {
        return type == AtomType.UNTYPED_ATOMIC ? Atm.get(string) : (type == AtomType.ANY_URI ? Uri.get(string) : Str.get(string, type));
    }
}

