/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.net.URL;
import java.nio.file.Path;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class SystemVariablesResolver
implements IVariableResolver {
    public static final SystemVariablesResolver INSTANCE = new SystemVariablesResolver();
    public static final String VAR_APP_NAME = "application.name";
    public static final String VAR_APP_VERSION = "application.version";
    public static final String VAR_APP_PATH = "application.path";
    public static final String VAR_WORKSPACE = "workspace";
    public static final String VAR_HOME = "home";
    public static final String VAR_DBEAVER_HOME = "dbeaver_home";
    public static final String VAR_LOCAL_IP = "local.ip";
    private static Properties configuration;
    private static String installPath;

    public static void setConfiguration(Properties configuration) {
        SystemVariablesResolver.configuration = configuration;
    }

    protected boolean isResolveSystemVariables() {
        return true;
    }

    @Override
    @Nullable
    public String get(@NotNull String name) {
        Object o;
        switch (name) {
            case "application.name": {
                return GeneralUtils.getProductName();
            }
            case "application.version": {
                return GeneralUtils.getProductVersion().toString();
            }
            case "home": {
                return SystemVariablesResolver.getUserHome();
            }
            case "workspace": {
                return SystemVariablesResolver.getWorkspacePath();
            }
            case "application.path": 
            case "dbeaver_home": {
                return SystemVariablesResolver.getInstallPath();
            }
            case "local.ip": {
                return RuntimeUtils.getLocalHostOrLoopback().getHostAddress();
            }
        }
        if (configuration != null && (o = configuration.get(name)) != null) {
            return o.toString();
        }
        if (this.isResolveSystemVariables()) {
            String var = System.getProperty(name);
            if (var != null) {
                return var;
            }
            return System.getenv(name);
        }
        return null;
    }

    @NotNull
    public static String getInstallPath() {
        if (installPath == null) {
            installPath = SystemVariablesResolver.getPlainPath(Platform.getInstallLocation().getURL());
        }
        return installPath;
    }

    @NotNull
    public static String getWorkspacePath() {
        if (DBWorkbench.isPlatformStarted()) {
            return DBFUtils.convertPathToString(DBWorkbench.getPlatform().getWorkspace().getAbsolutePath());
        }
        return SystemVariablesResolver.getPlainPath(Platform.getInstanceLocation().getURL());
    }

    @NotNull
    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    @NotNull
    private static String getPlainPath(@NotNull URL url) {
        try {
            Path file = RuntimeUtils.getLocalFileFromURL(url);
            return file.toAbsolutePath().toString();
        }
        catch (Exception exception) {
            return url.toString();
        }
    }
}

