/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.wizard;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskSettingsInput;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.registry.task.TaskTypeDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigurator;
import org.jkiss.dbeaver.tasks.ui.internal.TaskUIMessages;
import org.jkiss.dbeaver.tasks.ui.registry.TaskUIRegistry;
import org.jkiss.dbeaver.tasks.ui.wizard.NewTaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardPageSettings;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardPageTask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.IWizardPageNavigable;
import org.jkiss.dbeaver.ui.dialogs.MultiPageWizardDialog;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class TaskConfigurationWizardDialog
extends MultiPageWizardDialog {
    private static final Log log = Log.getLog(TaskConfigurationWizardDialog.class);
    private TaskConfigurationWizard<?> nestedTaskWizard;
    private TaskConfigurationWizardPageTask taskEditPage;
    private boolean editMode;
    private boolean selectorMode;

    public TaskConfigurationWizardDialog(IWorkbenchWindow window, TaskConfigurationWizard<?> wizard) {
        this(window, wizard, null);
    }

    public TaskConfigurationWizardDialog(IWorkbenchWindow window, TaskConfigurationWizard<?> wizard, IStructuredSelection selection) {
        super(window, wizard, selection);
        this.setFinishButtonLabel(IDialogConstants.PROCEED_LABEL);
        if (selection != null && !selection.isEmpty() && wizard.getSettings() instanceof DBTTaskSettingsInput) {
            ArrayList<Object> inputObjects = new ArrayList<Object>();
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object so = objectArray[n2];
                if (wizard.getTaskType().isObjectApplicable(so)) {
                    inputObjects.add(so);
                }
                ++n2;
            }
            ((DBTTaskSettingsInput)wizard.getSettings()).loadSettingsFromInput(inputObjects);
        }
        this.addPageChangedListener(new IPageChangedListener(){

            public void pageChanged(PageChangedEvent event) {
                TaskConfigurationWizardDialog.this.removePageChangedListener(this);
                TaskConfigurationWizardDialog.this.getWizard().onWizardActivation();
            }
        });
    }

    public TaskConfigurationWizardDialog(IWorkbenchWindow window) {
        this(window, new NewTaskConfigurationWizard(), null);
    }

    protected boolean isModalWizard() {
        return RuntimeUtils.isLinux();
    }

    public TaskConfigurationWizard<?> getWizard() {
        return (TaskConfigurationWizard)super.getWizard();
    }

    @NotNull
    protected Set<MultiPageWizardDialog.PageCompletionMark> getShownCompletionMarks() {
        if (this.getWizard().isCurrentTaskSaved()) {
            return EnumSet.noneOf(MultiPageWizardDialog.PageCompletionMark.class);
        }
        return EnumSet.of(MultiPageWizardDialog.PageCompletionMark.COMPLETE);
    }

    protected boolean isDisableControlsOnRun() {
        return true;
    }

    public TaskConfigurationWizard<?> getTaskWizard() {
        return (TaskConfigurationWizard)super.getWizard();
    }

    protected Control createDialogArea(Composite parent) {
        this.setHelpAvailable(false);
        Control dialogArea = super.createDialogArea(parent);
        this.getWizard().initializeWizard(parent);
        return dialogArea;
    }

    protected void createBottomLeftArea(Composite pane) {
        this.getWizard().createTaskActions(pane, 1);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ++((GridLayout)parent.getLayout()).numColumns;
        if (this.getWizard().isNewTaskEditor() || this.getNavPagesCount() > 1) {
            this.createButton(parent, 14, IDialogConstants.BACK_LABEL, false);
            Button nextButton = this.createButton(parent, 15, IDialogConstants.NEXT_LABEL, false);
            UIUtils.asyncExec(() -> this.getShell().setDefaultButton(nextButton));
        }
        super.createButtonsForButtonBar(parent);
    }

    private int getNavPagesCount() {
        int navPagesNum = 0;
        IWizardPage[] iWizardPageArray = this.getWizard().getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page2 = iWizardPageArray[n2];
            if (!(page2 instanceof IWizardPageNavigable) || ((IWizardPageNavigable)page2).isPageApplicable() && ((IWizardPageNavigable)page2).isPageNavigable()) {
                ++navPagesNum;
            }
            ++n2;
        }
        return navPagesNum;
    }

    public void disableButtonsOnProgress() {
        Button button = this.getButton(14);
        if (button != null) {
            button.setEnabled(false);
        }
        this.getWizard().enableTaskButtons(false);
        super.disableButtonsOnProgress();
    }

    public void enableButtonsAfterProgress() {
        Button button = this.getButton(14);
        if (button != null) {
            button.setEnabled(true);
        }
        this.getWizard().enableTaskButtons(true);
        super.enableButtonsAfterProgress();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 15 && this.getWizard() instanceof NewTaskConfigurationWizard && ((NewTaskConfigurationWizard)this.getWizard()).isLastTaskPreconfigPage(this.getCurrentPage())) {
            if (!this.getCurrentPage().isPageComplete()) {
                return;
            }
            this.taskEditPage = this.getTaskPage();
            try {
                TaskConfigurationWizard nextTaskWizard = this.taskEditPage.getTaskWizard();
                if (nextTaskWizard != this.nestedTaskWizard) {
                    this.nestedTaskWizard = nextTaskWizard;
                    this.nestedTaskWizard.addPages();
                    this.nestedTaskWizard.initializeWizard(this.getShell().getParent());
                    this.setWizard((IWizard)this.nestedTaskWizard);
                }
            }
            catch (Exception e) {
                this.setErrorMessage(NLS.bind((String)TaskUIMessages.task_configuration_wizard_dialog_configuration_error, (Object)e.getMessage()));
                log.error((Object)("Can't create task " + this.taskEditPage.getSelectedTaskType().getName() + " configuration wizard"), (Throwable)e);
                return;
            }
            IWizardPage[] iWizardPageArray = this.nestedTaskWizard.getPages();
            int n = iWizardPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage nextPage;
                IWizardPage page = iWizardPageArray[n2];
                if (page instanceof TaskConfigurationWizardPageSettings && (nextPage = this.nestedTaskWizard.getNextPage(page)) != null) {
                    this.showPage(nextPage);
                    return;
                }
                ++n2;
            }
            this.showPage(this.nestedTaskWizard.getStartingPage());
            return;
        }
        super.buttonPressed(buttonId);
    }

    public void updateButtons() {
        Button finishButton;
        super.updateButtons();
        this.getWizard().updateTaskButtons();
        if (this.getTaskWizard().canFinish() && (finishButton = this.getButton(0)) != null && !finishButton.isDisposed()) {
            this.getShell().setDefaultButton(finishButton);
        }
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }

    TaskConfigurationWizardPageTask getTaskPage() {
        if (this.taskEditPage != null) {
            return this.taskEditPage;
        }
        IWizardPage[] pages = this.getWizard().getPages();
        if (pages.length > 0 && pages[0] instanceof TaskConfigurationWizardPageTask) {
            return (TaskConfigurationWizardPageTask)pages[0];
        }
        return null;
    }

    public DBTTask getTask() {
        return this.getWizard().getCurrentTask();
    }

    public boolean isSelectorMode() {
        return this.selectorMode;
    }

    public void setSelectorMode(boolean selectorMode) {
        this.selectorMode = selectorMode;
        if (selectorMode) {
            this.setFinishButtonLabel(TaskUIMessages.task_config_wizard_dialog_button_save);
        }
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    @NotNull
    protected IWizardPage getStartingPage() {
        return this.getWizard().getStartingPage();
    }

    public static int openNewTaskDialog(@NotNull IWorkbenchWindow window, @NotNull DBPProject project, @NotNull String taskTypeId, @NotNull IStructuredSelection selection) {
        return TaskConfigurationWizardDialog.openNewTaskDialogImpl(window, project, taskTypeId, selection, false);
    }

    public static int openNewToolTaskDialog(@NotNull IWorkbenchWindow window, @NotNull DBPProject project, @NotNull String taskTypeId, @NotNull IStructuredSelection selection) {
        return TaskConfigurationWizardDialog.openNewTaskDialogImpl(window, project, taskTypeId, selection, true);
    }

    private static int openNewTaskDialogImpl(@NotNull IWorkbenchWindow window, @NotNull DBPProject project, @NotNull String taskTypeId, @NotNull IStructuredSelection selection, boolean isToolTask) {
        TaskTypeDescriptor taskType = TaskRegistry.getInstance().getTaskType(taskTypeId);
        if (taskType == null) {
            DBWorkbench.getPlatformUI().showError("Bad task type", "Task type '" + taskTypeId + "' not found");
            return 1;
        }
        try {
            DBTTaskConfigurator configurator;
            TaskConfigurationWizard configWizard;
            DBTTask task = project.getTaskManager().createTemporaryTask((DBTTaskType)taskType, taskType.getName());
            task.setProperties(new HashMap());
            if (isToolTask) {
                task.getProperties().put("isToolTask", true);
            }
            if ((configWizard = (configurator = TaskUIRegistry.getInstance().createConfigurator((DBTTaskType)taskType)).createTaskConfigWizard(task)) != null) {
                TaskConfigurationWizardDialog dialog = configWizard.createWizardDialog(window, selection);
                return dialog.open();
            }
            return 7;
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Task create error", "Error creating task '" + taskTypeId + "'", (Throwable)e);
            return 1;
        }
    }
}

