/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableConstraint;
import org.jkiss.dbeaver.ext.generic.model.GenericUniqueKey;
import org.jkiss.dbeaver.model.DBPScriptObjectExt2;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityConstrainable;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintInfo;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.utils.CommonUtils;

public class GenericTable
extends GenericTableBase
implements DBPScriptObjectExt2,
DBSEntityConstrainable {
    private String ddl;

    public GenericTable(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
    }

    public GenericTable(@NotNull GenericStructContainer container, @Nullable String tableName, @NotNull String tableCatalogName, @NotNull String tableSchemaName) {
        super(container, tableName, "TABLE", tableCatalogName, tableSchemaName);
    }

    public boolean isView() {
        return false;
    }

    @Override
    public String getDDL() {
        return this.ddl;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        if (CommonUtils.getOption(options, (String)"refresh")) {
            this.ddl = null;
        }
        if (!this.isPersisted()) {
            return DBStructUtils.generateTableDDL((DBRProgressMonitor)monitor, (DBSEntity)this, options, (boolean)false);
        }
        if (this.ddl == null || !this.isCacheDDL()) {
            this.ddl = ((GenericDataSource)this.getDataSource()).getMetaModel().getTableDDL(monitor, this, options);
        }
        return this.ddl;
    }

    protected boolean isCacheDDL() {
        return true;
    }

    public boolean supportsObjectDefinitionOption(@NotNull String option) {
        if ("ddl.onlyForeignKeys".equals(option) || "ddl.skipForeignKeys".equals(option)) {
            return !this.isPersisted() || ((GenericDataSource)this.getDataSource()).getMetaModel().supportsTableDDLSplit(this);
        }
        return false;
    }

    @NotNull
    public List<DBSEntityConstraintInfo> getSupportedConstraints() {
        boolean isSupportCheckConstraint = ((GenericDataSource)this.getDataSource()).getMetaModel().supportsCheckConstraints();
        ArrayList<DBSEntityConstraintInfo> result = new ArrayList<DBSEntityConstraintInfo>();
        result.add(DBSEntityConstraintInfo.of((DBSEntityConstraintType)DBSEntityConstraintType.PRIMARY_KEY, GenericUniqueKey.class));
        if (((GenericDataSource)this.getDataSource()).getMetaModel().supportsUniqueKeys()) {
            result.add(DBSEntityConstraintInfo.of((DBSEntityConstraintType)DBSEntityConstraintType.UNIQUE_KEY, GenericUniqueKey.class));
        }
        if (isSupportCheckConstraint) {
            result.add(DBSEntityConstraintInfo.of((DBSEntityConstraintType)DBSEntityConstraintType.CHECK, GenericTableConstraint.class));
        }
        return result;
    }
}

