/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.firebird.FireBirdUtils;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTableBase;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectWithScript;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;

public class FireBirdView
extends GenericView
implements FireBirdTableBase,
DBSObjectWithScript,
DBSView {
    private String ownerName;
    private Map<String, String> columnDomainTypes;

    public FireBirdView(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
        if (dbResult != null) {
            this.ownerName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"RDB$OWNER_NAME");
        }
    }

    public boolean isView() {
        return true;
    }

    @Override
    @Property(viewable=true, order=20)
    public String getOwnerName() {
        return this.ownerName;
    }

    @Override
    public synchronized List<FireBirdTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        List childColumns = super.getAttributes(monitor);
        if (childColumns == null) {
            return Collections.emptyList();
        }
        ArrayList<FireBirdTableColumn> columns = new ArrayList<FireBirdTableColumn>();
        for (GenericTableColumn gtc : childColumns) {
            columns.add((FireBirdTableColumn)gtc);
        }
        columns.sort(DBUtils.orderComparator());
        return columns;
    }

    @Override
    public String getColumnDomainType(DBRProgressMonitor monitor, FireBirdTableColumn column) throws DBException {
        if (this.columnDomainTypes == null) {
            this.columnDomainTypes = FireBirdUtils.readColumnDomainTypes(monitor, (GenericTableBase)this);
        }
        return this.columnDomainTypes.get(column.getName());
    }
}

