/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data;

import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DBDAttributeConstraintBase {
    public static final String ATTR_OPTION_PINNED = "pinned";
    public static int NULL_VISUAL_POSITION = -1;
    private int orderPosition;
    private boolean orderDescending;
    @Nullable
    private String criteria;
    @Nullable
    private DBCLogicalOperator operator;
    private boolean reverseOperator;
    @Nullable
    private Object value;
    private boolean visible;
    private int visualPosition;
    @Nullable
    private String entityAlias;
    @Nullable
    private Object[] options;

    public DBDAttributeConstraintBase() {
    }

    public DBDAttributeConstraintBase(@NotNull DBDAttributeConstraintBase source) {
        this.copyFrom(source);
    }

    public void copyFrom(@NotNull DBDAttributeConstraintBase source) {
        this.orderPosition = source.orderPosition;
        this.orderDescending = source.orderDescending;
        this.criteria = source.criteria;
        this.operator = source.operator;
        this.reverseOperator = source.reverseOperator;
        this.value = source.value;
        this.visible = source.visible;
        this.visualPosition = source.visualPosition;
        this.options = source.options;
    }

    public int getOrderPosition() {
        return this.orderPosition;
    }

    public void setOrderPosition(int orderPosition) {
        this.orderPosition = orderPosition;
    }

    public boolean isOrderDescending() {
        return this.orderDescending;
    }

    public void setOrderDescending(boolean orderDescending) {
        this.orderDescending = orderDescending;
    }

    @Nullable
    public String getCriteria() {
        return this.criteria;
    }

    public void setCriteria(@Nullable String criteria) {
        this.criteria = criteria;
        this.operator = null;
        this.reverseOperator = false;
        this.value = null;
    }

    @Nullable
    public DBCLogicalOperator getOperator() {
        return this.operator;
    }

    public void setOperator(@Nullable DBCLogicalOperator operator) {
        this.criteria = null;
        this.operator = operator;
    }

    public boolean isReverseOperator() {
        return this.reverseOperator;
    }

    public void setReverseOperator(boolean reverseOperator) {
        this.reverseOperator = reverseOperator;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public void setValue(@Nullable Object value) {
        this.criteria = null;
        this.value = value;
    }

    public boolean hasFilter() {
        return this.hasCondition() || this.orderPosition > 0;
    }

    public boolean isDirty() {
        return this.hasFilter() || !this.visible || !ArrayUtils.isEmpty((Object[])this.options);
    }

    public boolean hasCondition() {
        return !CommonUtils.isEmpty((String)this.criteria) || this.operator != null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getVisualPosition() {
        return this.visualPosition;
    }

    public void setVisualPosition(int visualPosition) {
        this.visualPosition = visualPosition;
    }

    public String getEntityAlias() {
        return this.entityAlias;
    }

    public void setEntityAlias(String entityAlias) {
        this.entityAlias = entityAlias;
    }

    @Nullable
    public Object[] getOptions() {
        return this.options;
    }

    public void setOptions(@Nullable Object[] options) {
        this.options = options;
    }

    public boolean hasOption(String option) {
        if (this.options == null) {
            return false;
        }
        int i = 0;
        while (i < this.options.length) {
            if (this.options[i].equals(option)) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    public <T> T getOption(String option) {
        if (this.options == null) {
            return null;
        }
        int i = 0;
        while (i < this.options.length) {
            if (this.options[i].equals(option)) {
                return (T)this.options[i + 1];
            }
            i += 2;
        }
        return null;
    }

    public void setOption(String option, Object value) {
        Object[] newOptions = new Object[]{option, value};
        if (this.options == null) {
            this.options = newOptions;
        } else {
            int i = 0;
            while (i < this.options.length) {
                if (this.options[i].equals(option)) {
                    this.options[i + 1] = value;
                    return;
                }
                i += 2;
            }
            this.options = ArrayUtils.concatArrays((Object[])this.options, (Object[])newOptions);
        }
    }

    public boolean removeOption(String option) {
        if (this.options == null) {
            return false;
        }
        int i = 0;
        while (i < this.options.length) {
            if (this.options[i].equals(option)) {
                this.options = ArrayUtils.remove(Object.class, (Object[])ArrayUtils.remove(Object.class, (Object[])this.options, (int)i), (int)i);
                return true;
            }
            i += 2;
        }
        return false;
    }

    public void reset() {
        this.orderPosition = 0;
        this.orderDescending = false;
        this.criteria = null;
        this.operator = null;
        this.reverseOperator = false;
        this.value = null;
        this.visible = true;
        this.options = null;
    }

    public boolean equalFilters(DBDAttributeConstraintBase obj, boolean compareOrders) {
        if (compareOrders && (this.orderPosition != obj.orderPosition || this.orderDescending != obj.orderDescending)) {
            return false;
        }
        return CommonUtils.equalObjects((Object)this.criteria, (Object)obj.criteria) && CommonUtils.equalObjects((Object)((Object)this.operator), (Object)((Object)obj.operator)) && CommonUtils.equalObjects((Object)this.reverseOperator, (Object)obj.reverseOperator) && CommonUtils.equalObjects((Object)this.value, (Object)obj.value);
    }

    public int hashCode() {
        return this.orderPosition + (this.orderDescending ? 1 : 0) + (this.criteria == null ? 0 : this.criteria.hashCode()) + (this.operator == null ? 0 : this.operator.hashCode()) + (this.reverseOperator ? 1 : 0) + (this.value == null ? 0 : this.value.hashCode()) + (this.visible ? 1 : 0) + this.visualPosition;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DBDAttributeConstraintBase) {
            DBDAttributeConstraintBase source = (DBDAttributeConstraintBase)obj;
            return this.orderPosition == source.orderPosition && this.orderDescending == source.orderDescending && CommonUtils.equalObjects((Object)this.criteria, (Object)source.criteria) && CommonUtils.equalObjects((Object)((Object)this.operator), (Object)((Object)source.operator)) && this.reverseOperator == source.reverseOperator && CommonUtils.equalObjects((Object)this.value, (Object)source.value) && this.visible == source.visible && this.visualPosition == source.visualPosition && Arrays.equals(this.options, source.options);
        }
        return false;
    }
}

