/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class DefaultRangeIndicator
extends Annotation
implements IAnnotationPresentation {
    private static final String RANGE_INDICATOR_COLOR = "org.eclipse.ui.editors.rangeIndicatorColor";
    private Image fImage;
    private Color fLastRangeIndicatorColor;

    public void paint(GC gc, Canvas canvas, Rectangle bounds) {
        Point canvasSize = canvas.getSize();
        int x = 0;
        int y = bounds.y;
        int w = canvasSize.x;
        int h = bounds.height;
        int b = 1;
        if (y + h > canvasSize.y) {
            h = canvasSize.y - y;
        }
        if (y < 0) {
            h += y;
            y = 0;
        }
        if (h <= 0) {
            return;
        }
        Color currentRangeIndicatorColor = JFaceResources.getColorRegistry().get(RANGE_INDICATOR_COLOR);
        Image image = this.getImage((Control)canvas, currentRangeIndicatorColor);
        gc.drawImage(image, 0, 0, w, h, x, y, w, h);
        gc.setBackground(currentRangeIndicatorColor);
        gc.fillRectangle(x, bounds.y, w, b);
        gc.fillRectangle(x, bounds.y + bounds.height - b, w, b);
        this.fLastRangeIndicatorColor = currentRangeIndicatorColor;
    }

    public int getLayer() {
        return 0;
    }

    private Image getImage(Control control, Color rangeIndicatorColor) {
        if (this.fImage == null) {
            this.fImage = DefaultRangeIndicator.createImage(control.getDisplay(), control.getSize(), rangeIndicatorColor);
            control.addDisposeListener(e -> {
                if (this.fImage != null && !this.fImage.isDisposed()) {
                    this.fImage.dispose();
                    this.fImage = null;
                }
            });
        } else {
            Rectangle imageRectangle = this.fImage.getBounds();
            Point controlSize = control.getSize();
            if (imageRectangle.width < controlSize.x || imageRectangle.height < controlSize.y || !rangeIndicatorColor.equals((Object)this.fLastRangeIndicatorColor)) {
                this.fImage.dispose();
                this.fImage = DefaultRangeIndicator.createImage(control.getDisplay(), controlSize, rangeIndicatorColor);
            }
        }
        return this.fImage;
    }

    private static Image createImage(Display display, Point size, Color rangeIndicatorColor) {
        int width = size.x;
        int height = size.y;
        ImageDataProvider imageDataProvider = zoom -> {
            float scaleFactor = (float)zoom / 100.0f;
            int scaledWidth = Math.round((float)width * scaleFactor);
            int scaledHeight = Math.round((float)height * scaleFactor);
            ImageData imageData = new ImageData(scaledWidth, scaledHeight, 1, DefaultRangeIndicator.createPalette(display, rangeIndicatorColor));
            int blockSize = Math.round(scaleFactor);
            int y = 0;
            while (y < scaledHeight) {
                int x = 0;
                while (x < scaledWidth) {
                    if ((x / blockSize + y / blockSize) % 2 == 0) {
                        imageData.setPixel(x, y, 1);
                    }
                    ++x;
                }
                ++y;
            }
            imageData.transparentPixel = 1;
            return imageData;
        };
        return new Image((Device)display, imageDataProvider);
    }

    private static PaletteData createPalette(Display display, Color rangeIndicatorColor) {
        return new PaletteData(new RGB[]{rangeIndicatorColor.getRGB(), display.getSystemColor(22).getRGB()});
    }
}

