/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.encoding;

import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.encoding.Binary;
import org.sat4j.tools.encoding.Binomial;
import org.sat4j.tools.encoding.Commander;
import org.sat4j.tools.encoding.EncodingStrategy;
import org.sat4j.tools.encoding.EncodingStrategyAdapter;
import org.sat4j.tools.encoding.Ladder;
import org.sat4j.tools.encoding.Product;
import org.sat4j.tools.encoding.Sequential;

public class Policy
extends EncodingStrategyAdapter {
    private static final long serialVersionUID = 1L;
    private static final Sequential seq = new Sequential();
    private static final Binary binary = new Binary();
    private static final Product product = new Product();
    private static final Commander commander = new Commander();
    private static final Binomial binomial = new Binomial();
    private static final Ladder ladder = new Ladder();
    private EncodingStrategyAdapter atMostOneEncoding = null;
    private EncodingStrategyAdapter atMostKEncoding = null;
    private EncodingStrategyAdapter exactlyOneEncoding = null;
    private EncodingStrategyAdapter exactlyKEncoding = null;
    private EncodingStrategyAdapter atLeastOneEncoding = null;
    private EncodingStrategyAdapter atLeastKEncoding = null;

    public static EncodingStrategyAdapter getAdapterFromEncodingName(EncodingStrategy encodingName) {
        switch (encodingName) {
            case BINARY: {
                return binary;
            }
            case BINOMIAL: {
                return binomial;
            }
            case COMMANDER: {
                return commander;
            }
            case LADDER: {
                return ladder;
            }
            case PRODUCT: {
                return product;
            }
            case SEQUENTIAL: {
                return seq;
            }
        }
        throw new IllegalStateException("The switch does not cover all encodings");
    }

    public static EncodingStrategy getEncodingTypeFromAdapter(EncodingStrategyAdapter adapter) {
        if (adapter instanceof Binary) {
            return EncodingStrategy.BINARY;
        }
        if (adapter instanceof Binomial) {
            return EncodingStrategy.BINOMIAL;
        }
        if (adapter instanceof Commander) {
            return EncodingStrategy.COMMANDER;
        }
        if (adapter instanceof Ladder) {
            return EncodingStrategy.LADDER;
        }
        if (adapter instanceof Product) {
            return EncodingStrategy.PRODUCT;
        }
        if (adapter instanceof Sequential) {
            return EncodingStrategy.SEQUENTIAL;
        }
        return EncodingStrategy.NATIVE;
    }

    public EncodingStrategyAdapter getAtMostOneEncoding() {
        return this.atMostOneEncoding;
    }

    public void setAtMostOneEncoding(EncodingStrategyAdapter atMostOneEncoding) {
        this.atMostOneEncoding = atMostOneEncoding;
    }

    public void setAtMostOneEncoding(EncodingStrategy atMostOneEncoding) {
        this.atMostOneEncoding = Policy.getAdapterFromEncodingName(atMostOneEncoding);
    }

    public EncodingStrategyAdapter getAtMostKEncoding() {
        return this.atMostKEncoding;
    }

    public void setAtMostKEncoding(EncodingStrategyAdapter atMostKEncoding) {
        this.atMostKEncoding = atMostKEncoding;
    }

    public void setAtMostKEncoding(EncodingStrategy atMostKEncoding) {
        this.atMostKEncoding = Policy.getAdapterFromEncodingName(atMostKEncoding);
    }

    public EncodingStrategyAdapter getExactlyOneEncoding() {
        return this.exactlyOneEncoding;
    }

    public void setExactlyOneEncoding(EncodingStrategyAdapter exactlyOneEncoding) {
        this.exactlyOneEncoding = exactlyOneEncoding;
    }

    public void setExactlyOneEncoding(EncodingStrategy exactlyOneEncoding) {
        this.exactlyOneEncoding = Policy.getAdapterFromEncodingName(exactlyOneEncoding);
    }

    public EncodingStrategyAdapter getExactlyKEncoding() {
        return this.exactlyKEncoding;
    }

    public void setExactlyKEncoding(EncodingStrategyAdapter exactlyKEncoding) {
        this.exactlyKEncoding = exactlyKEncoding;
    }

    public void setExactlyKEncoding(EncodingStrategy exactlyKEncoding) {
        this.exactlyKEncoding = Policy.getAdapterFromEncodingName(exactlyKEncoding);
    }

    public EncodingStrategyAdapter getAtLeastOneEncoding() {
        return this.atLeastOneEncoding;
    }

    public void setAtLeastOneEncoding(EncodingStrategyAdapter atLeastOneEncoding) {
        this.atLeastOneEncoding = atLeastOneEncoding;
    }

    public void setAtLeastOneEncoding(EncodingStrategy atLeastOneEncoding) {
        this.atLeastOneEncoding = Policy.getAdapterFromEncodingName(atLeastOneEncoding);
    }

    public EncodingStrategyAdapter getAtLeastKEncoding() {
        return this.atLeastKEncoding;
    }

    public void setAtLeastKEncoding(EncodingStrategyAdapter atLeastKEncoding) {
        this.atLeastKEncoding = atLeastKEncoding;
    }

    public void setAtLeastKEncoding(EncodingStrategy atLeastKEncoding) {
        this.atLeastKEncoding = Policy.getAdapterFromEncodingName(atLeastKEncoding);
    }

    @Override
    public IConstr addAtMost(ISolver solver, IVecInt literals, int k) throws ContradictionException {
        if (k == 0 || literals.size() == 1) {
            return super.addAtMost(solver, literals, k);
        }
        if (literals.size() <= 1) {
            throw new UnsupportedOperationException("requires at least 2 literals");
        }
        if (k == 1 && this.atMostOneEncoding != null) {
            return this.atMostOneEncoding.addAtMostOne(solver, literals);
        }
        if (this.atMostKEncoding != null) {
            if (k == 1) {
                return this.atMostKEncoding.addAtMostOne(solver, literals);
            }
            return this.atMostKEncoding.addAtMost(solver, literals, k);
        }
        return super.addAtMost(solver, literals, k);
    }

    @Override
    public IConstr addExactly(ISolver solver, IVecInt literals, int n) throws ContradictionException {
        if (n == 1 && this.exactlyOneEncoding != null) {
            return this.exactlyOneEncoding.addExactlyOne(solver, literals);
        }
        if (this.exactlyKEncoding != null) {
            if (n == 1) {
                return this.exactlyKEncoding.addExactlyOne(solver, literals);
            }
            return this.exactlyKEncoding.addExactly(solver, literals, n);
        }
        return super.addExactly(solver, literals, n);
    }

    @Override
    public IConstr addAtLeast(ISolver solver, IVecInt literals, int n) throws ContradictionException {
        if (n == 1) {
            if (this.atLeastOneEncoding != null) {
                return this.atLeastOneEncoding.addAtLeastOne(solver, literals);
            }
        } else if (this.atLeastKEncoding != null) {
            return this.atLeastKEncoding.addAtLeast(solver, literals, n);
        }
        return super.addAtLeast(solver, literals, n);
    }

    @Override
    public String toString() {
        String s = "";
        s = s + "Policy = [At most K: " + (Object)((Object)Policy.getEncodingTypeFromAdapter(this.getAtMostKEncoding())) + ", at most 1: " + (Object)((Object)Policy.getEncodingTypeFromAdapter(this.getAtMostOneEncoding())) + ", exactly K: " + (Object)((Object)Policy.getEncodingTypeFromAdapter(this.getExactlyKEncoding())) + ", exactly 1: " + (Object)((Object)Policy.getEncodingTypeFromAdapter(this.getExactlyOneEncoding())) + "]";
        return s;
    }
}

