/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScope;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSetOperationModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryRowsCrossJoinModel
extends SQLQueryRowsSetOperationModel
implements SQLQueryNodeModel.NodeSubtreeTraverseControl<SQLQueryRowsSourceModel, SQLQueryRowsDataContext> {
    private final boolean isLateral;
    @Nullable
    private final SQLQueryLexicalScope rightSourceScope;

    public SQLQueryRowsCrossJoinModel(@NotNull Interval range, @NotNull STMTreeNode syntaxNode, @NotNull SQLQueryRowsSourceModel left, @NotNull SQLQueryRowsSourceModel right, @Nullable SQLQueryLexicalScope rightSourceScope, boolean isLateral) {
        super(range, syntaxNode, left, right);
        this.rightSourceScope = rightSourceScope;
        this.isLateral = isLateral;
        if (rightSourceScope != null) {
            this.registerLexicalScope(rightSourceScope);
        }
    }

    @Override
    protected SQLQueryRowsSourceContext resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryRowsSourceContext left = this.left.resolveRowSources(context, statistics);
        SQLQueryRowsSourceContext right = this.right != null ? this.right.resolveRowSources(this.isLateral ? left : context, statistics) : context.resetAsUnresolved();
        SQLQueryRowsSourceContext combined = left.combine(right);
        return combined;
    }

    @Override
    public boolean overridesContextForChild(@NotNull SQLQueryRowsSourceModel child) {
        return this.isLateral && child == this.right;
    }

    @Override
    @Nullable
    public SQLQueryRowsDataContext getContextForChild(@NotNull SQLQueryRowsSourceModel child, @Nullable SQLQueryRowsDataContext defaultContext) {
        return this.isLateral && child == this.right ? this.left.getRowsDataContext() : defaultContext;
    }

    @Override
    protected SQLQueryRowsDataContext resolveRowDataImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQuerySymbolOrigin.RowsSourceRef rightSourceOrigin = new SQLQuerySymbolOrigin.RowsSourceRef(this.getRowsSources());
        if (this.rightSourceScope != null) {
            this.rightSourceScope.setSymbolsOrigin(rightSourceOrigin);
            this.setTailOrigin(rightSourceOrigin);
        }
        if (this.right != null) {
            return this.left.getRowsDataContext().combine(this.right.getRowsDataContext());
        }
        statistics.appendError(this.getSyntaxNode(), "Table to join is not specified");
        return this.left.getRowsDataContext();
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitRowsCrossJoin(this, arg);
    }
}

