/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import java.time.Duration;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.widgets.SpinnerFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.UIUtils;

public final class DurationPickerDialog
extends Dialog {
    private final String title;
    private int hours;
    private int minutes;
    private int seconds;

    public DurationPickerDialog(@NotNull Shell parentShell, @Nullable String title, @Nullable Duration duration) {
        super(parentShell);
        this.title = title;
        if (duration != null) {
            this.hours = Math.toIntExact(duration.toHours());
            this.minutes = duration.toMinutesPart();
            this.seconds = duration.toSecondsPart();
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.title != null) {
            newShell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 3;
        UIUtils.createControlLabel(composite, "Hours");
        UIUtils.createControlLabel(composite, "Minutes");
        UIUtils.createControlLabel(composite, "Seconds");
        this.createSpinner(composite, 23, () -> this.hours, value -> {
            int n = this.hours = value;
        });
        this.createSpinner(composite, 59, () -> this.minutes, value -> {
            int n = this.minutes = value;
        });
        this.createSpinner(composite, 59, () -> this.seconds, value -> {
            int n = this.seconds = value;
        });
        UIUtils.asyncExec(this::updateCompletion);
        return composite;
    }

    private void createSpinner(@NotNull Composite parent, int maximum, @NotNull IntSupplier getter, @NotNull IntConsumer setter) {
        ((Spinner)((SpinnerFactory)SpinnerFactory.newSpinner((int)2048).bounds(0, maximum).layoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create())).onSelect(e -> {
            setter.accept(((Spinner)e.widget).getSelection());
            this.updateCompletion();
        }).create((Widget)parent)).setSelection(getter.getAsInt());
    }

    @NotNull
    public Duration getDuration() {
        return Duration.ofHours(this.hours).plusMinutes(this.minutes).plusSeconds(this.seconds);
    }

    private void updateCompletion() {
        this.getButton(0).setEnabled(this.getDuration().isPositive());
    }
}

