/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScope;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryModelRecognizer;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryTreeMapper;
import org.jkiss.dbeaver.model.sql.semantics.model.dml.SQLQuerySelectIntoModel;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueFlattenedExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsCorrelatedSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsCrossJoinModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsCteModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsCteSubqueryModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsNaturalJoinModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsProjectionModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSetCorrespondingOperationKind;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSetCorrespondingOperationModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableProcModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsTableValueModel;
import org.jkiss.dbeaver.model.stm.STMKnownRuleNames;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.stm.STMTreeTermNode;
import org.jkiss.dbeaver.model.stm.STMUtils;

public class SQLQueryExpressionMapper
extends SQLQueryTreeMapper<SQLQueryRowsSourceModel, SQLQueryModelRecognizer> {
    private static final Log log = Log.getLog(SQLQueryExpressionMapper.class);
    @NotNull
    private static final Set<String> queryExpressionSubtreeNodeNames = Set.of(STMKnownRuleNames.sqlQuery, STMKnownRuleNames.directSqlDataStatement, STMKnownRuleNames.selectStatement, STMKnownRuleNames.withClause, STMKnownRuleNames.cteList, STMKnownRuleNames.with_list_element, STMKnownRuleNames.subquery, STMKnownRuleNames.unionTerm, STMKnownRuleNames.exceptTerm, STMKnownRuleNames.nonJoinQueryExpression, STMKnownRuleNames.nonJoinQueryTerm, STMKnownRuleNames.intersectTerm, STMKnownRuleNames.nonJoinQueryPrimary, STMKnownRuleNames.simpleTable, STMKnownRuleNames.querySpecification, STMKnownRuleNames.tableExpression, STMKnownRuleNames.queryPrimary, STMKnownRuleNames.queryTerm, STMKnownRuleNames.queryExpression, STMKnownRuleNames.selectStatementSingleRow, STMKnownRuleNames.fromClause, STMKnownRuleNames.nonjoinedTableReference, STMKnownRuleNames.tableReference, STMKnownRuleNames.fromClauseTerm, STMKnownRuleNames.joinedTable, STMKnownRuleNames.derivedTable, STMKnownRuleNames.tableSubquery, STMKnownRuleNames.crossJoinTerm, STMKnownRuleNames.naturalJoinTerm, STMKnownRuleNames.explicitTable);
    @NotNull
    private static final Map<String, SQLQueryTreeMapper.TreeMapperCallback<SQLQueryRowsSourceModel, SQLQueryModelRecognizer>> translations = Map.of(STMKnownRuleNames.directSqlDataStatement, (n, cc, r) -> {
        STMTreeNode withNode;
        if (cc.isEmpty()) {
            return null;
        }
        if (cc.size() == 1) {
            return (SQLQueryRowsSourceModel)cc.get(0);
        }
        List<SQLQueryRowsSourceModel> subqueries = cc.subList(0, cc.size() - 1);
        SQLQueryRowsSourceModel resultQuery = (SQLQueryRowsSourceModel)cc.get(cc.size() - 1);
        if (SQLQueryExpressionMapper.findImmediateChild(n, resultQuery.getSyntaxNode()) != n.findLastNonErrorChild()) {
            resultQuery = SQLQueryExpressionMapper.makeEmptyRowsModel(n.findLastNonErrorChild());
        }
        if ((withNode = n.findFirstChildOfName(STMKnownRuleNames.withClause)) != null) {
            ArrayList<SQLQueryRowsCteSubqueryModel> cteSubqueries = new ArrayList<SQLQueryRowsCteSubqueryModel>();
            STMTreeNode cteListNode = withNode.findLastChildOfName(STMKnownRuleNames.cteList);
            if (cteListNode != null) {
                SubsourcesMap subsources = new SubsourcesMap(subqueries, cteListNode);
                for (STMTreeNode cteSubqueryNode : cteListNode.findChildrenOfName(STMKnownRuleNames.with_list_element)) {
                    STMTreeNode subqueryTrailingNode;
                    STMTreeNode subqueryNameNode = cteSubqueryNode.findFirstChildOfName(STMKnownRuleNames.queryName);
                    SQLQuerySymbolEntry subqueryName = subqueryNameNode == null ? null : r.collectIdentifier(subqueryNameNode, null);
                    STMTreeNode columnListNode = cteSubqueryNode.findFirstChildOfName(STMKnownRuleNames.columnNameList);
                    List<SQLQuerySymbolEntry> columnList = columnListNode == null ? Collections.emptyList() : r.collectColumnNameList(columnListNode);
                    SQLQueryRowsSourceModel subquerySource = subsources.getOrEmpty(cteSubqueryNode);
                    SQLQueryLexicalScope subqueryTailScope = null;
                    STMTreeNode subqueryNode = cteSubqueryNode.findLastChildOfName(STMKnownRuleNames.subquery);
                    if (subqueryNode != null && (subqueryTrailingNode = subqueryNode.findLastChildOfName(STMKnownRuleNames.RIGHT_PAREN_TERM)) != null) {
                        subqueryTailScope = new SQLQueryLexicalScope();
                        subqueryTailScope.setInterval(Interval.of((int)(subquerySource.getInterval().b + 1), (int)(subqueryTrailingNode.getRealInterval().a - 1)));
                    }
                    cteSubqueries.add(new SQLQueryRowsCteSubqueryModel(cteSubqueryNode, subqueryName, columnList, subquerySource, subqueryTailScope));
                }
            }
            return new SQLQueryRowsCteModel(n, cteSubqueries, resultQuery);
        }
        return new SQLQueryRowsCteModel(n, Collections.emptyList(), resultQuery);
    }, STMKnownRuleNames.queryExpression, (n, cc, r) -> {
        if (cc.isEmpty()) {
            return SQLQueryExpressionMapper.makeEmptyRowsModel(n);
        }
        SubsourcesMap subsources = new SubsourcesMap(cc, n);
        List childNodes = n.findNonErrorChildren();
        SQLQueryRowsSourceModel source = subsources.getOrEmpty((STMTreeNode)childNodes.get(0));
        for (STMTreeNode childNode : childNodes.subList(1, childNodes.size())) {
            List<SQLQuerySymbolEntry> corresponding = r.collectColumnNameList(childNode);
            SQLQueryRowsSourceModel nextSource = subsources.getOrEmpty(childNode);
            Interval range = Interval.of((int)n.getRealInterval().a, (int)childNode.getRealInterval().b);
            SQLQueryRowsSetCorrespondingOperationKind opKind = switch (childNode.getNodeKindId()) {
                case 103 -> SQLQueryRowsSetCorrespondingOperationKind.EXCEPT;
                case 102 -> SQLQueryRowsSetCorrespondingOperationKind.UNION;
                default -> throw new UnsupportedOperationException("Unexpected child node kind at queryExpression: " + childNode.getNodeName());
            };
            source = new SQLQueryRowsSetCorrespondingOperationModel(range, childNode, source, nextSource, corresponding, opKind);
        }
        return source;
    }, STMKnownRuleNames.nonJoinQueryTerm, (n, cc, r) -> {
        if (cc.isEmpty()) {
            return SQLQueryExpressionMapper.makeEmptyRowsModel(n);
        }
        SubsourcesMap subsources = new SubsourcesMap(cc, n);
        List childNodes = n.findNonErrorChildren();
        SQLQueryRowsSourceModel source = subsources.getOrEmpty((STMTreeNode)childNodes.get(0));
        for (STMTreeNode childNode : childNodes.subList(1, childNodes.size())) {
            List<SQLQuerySymbolEntry> corresponding = r.collectColumnNameList(childNode);
            SQLQueryRowsSourceModel nextSource = subsources.getOrEmpty(childNode);
            Interval range = Interval.of((int)n.getRealInterval().a, (int)childNode.getRealInterval().b);
            switch (childNode.getNodeKindId()) {
                case 106: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unexpected child node kind at nonJoinQueryTerm: " + childNode.getNodeName());
                }
            }
            SQLQueryRowsSetCorrespondingOperationKind opKind = SQLQueryRowsSetCorrespondingOperationKind.INTERSECT;
            source = new SQLQueryRowsSetCorrespondingOperationModel(range, childNode, source, nextSource, corresponding, opKind);
        }
        return source;
    }, STMKnownRuleNames.joinedTable, (n, cc, r) -> {
        if (cc.isEmpty()) {
            return SQLQueryExpressionMapper.makeEmptyRowsModel(n);
        }
        SubsourcesMap subsources = new SubsourcesMap(cc, n);
        List childNodes = n.findNonErrorChildren();
        SQLQueryRowsSourceModel source = subsources.getOrEmpty((STMTreeNode)childNodes.get(0));
        for (STMTreeNode childNode : childNodes.subList(1, childNodes.size())) {
            SQLQueryRowsSourceModel sQLQueryRowsSourceModel;
            SQLQueryLexicalScope rightTableScope;
            if (childNode instanceof STMTreeTermNode) continue;
            SQLQueryRowsSourceModel currSource = source;
            SQLQueryRowsSourceModel nextSource = subsources.getOrNull(childNode);
            STMTreeNode lastTermChild = nextSource != null ? null : (STMTreeNode)STMUtils.expandTerms((STMTreeNode)childNode).getLast();
            SQLQueryLexicalScope sQLQueryLexicalScope = rightTableScope = lastTermChild == null ? null : new SQLQueryLexicalScope();
            if (lastTermChild != null) {
                rightTableScope.setInterval(Interval.of((int)(lastTermChild.getRealInterval().b + 1), (int)Integer.MAX_VALUE));
            }
            Interval range = Interval.of((int)n.getRealInterval().a, (int)childNode.getRealInterval().b);
            boolean isLateral = childNode.findFirstChildOfName(STMKnownRuleNames.LATERAL_TERM) != null;
            switch (childNode.getNodeKindId()) {
                case 130: {
                    Optional<STMTreeNode> joinSpecificationNode = Optional.ofNullable(childNode.findFirstChildOfName(STMKnownRuleNames.joinSpecification));
                    Optional<STMTreeNode> joinConditionNode = joinSpecificationNode.map(cn -> cn.findFirstChildOfName(STMKnownRuleNames.joinCondition));
                    Throwable throwable = null;
                    Object var17_18 = null;
                    try (SQLQueryModelRecognizer.LexicalScopeHolder condScope = r.openScope();){
                        if (joinSpecificationNode.isPresent()) {
                            if (joinConditionNode.isPresent()) {
                                joinSpecificationNode.map(cn -> cn.findFirstNonErrorChild()).map(cn -> cn.findFirstNonErrorChild()).filter(cn -> cn instanceof STMTreeTermNode).ifPresent(kw -> lexicalScopeHolder.lexicalScope.setInterval(Interval.of((int)(kw.getRealInterval().b + 2), (int)Integer.MAX_VALUE)));
                                sQLQueryRowsSourceModel = joinConditionNode.map(cn -> cn.findFirstChildOfName(STMKnownRuleNames.searchCondition)).map(cn -> r.collectValueExpression((STMTreeNode)cn, lexicalScopeHolder.lexicalScope)).map(e -> new SQLQueryRowsNaturalJoinModel(range, childNode, currSource, nextSource, rightTableScope, isLateral, (SQLQueryValueExpression)e, lexicalScopeHolder.lexicalScope)).orElseGet(() -> new SQLQueryRowsNaturalJoinModel(range, childNode, currSource, nextSource, rightTableScope, isLateral, null, lexicalScopeHolder.lexicalScope));
                                break;
                            }
                            Optional<STMTreeNode> columnsSpecNode = joinSpecificationNode.map(cn -> cn.findFirstNonErrorChild());
                            int condScopeEnd = columnsSpecNode.map(cn -> cn.findLastChildOfName(STMKnownRuleNames.RIGHT_PAREN_TERM)).map(cn -> cn.getRealInterval().a).orElse(Integer.MAX_VALUE);
                            columnsSpecNode.map(cn -> cn.findFirstChildOfName(STMKnownRuleNames.LEFT_PAREN_TERM)).ifPresent(cn -> lexicalScopeHolder.lexicalScope.setInterval(Interval.of((int)(cn.getRealInterval().b + 1), (int)condScopeEnd)));
                            sQLQueryRowsSourceModel = new SQLQueryRowsNaturalJoinModel(range, childNode, currSource, nextSource, rightTableScope, isLateral, r.collectColumnNameList(childNode), condScope.lexicalScope);
                            break;
                        }
                        sQLQueryRowsSourceModel = new SQLQueryRowsNaturalJoinModel(range, childNode, currSource, nextSource, rightTableScope, isLateral, null, condScope.lexicalScope);
                        break;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                case 129: {
                    sQLQueryRowsSourceModel = new SQLQueryRowsCrossJoinModel(range, childNode, currSource, nextSource, rightTableScope, isLateral);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unexpected child node kind at queryExpression: " + childNode.getNodeName());
                }
            }
            source = sQLQueryRowsSourceModel;
        }
        return source;
    }, STMKnownRuleNames.fromClause, (n, cc, r) -> {
        SQLQueryLexicalScope rightTableScope;
        STMTreeTermNode t;
        if (cc.isEmpty()) {
            return SQLQueryExpressionMapper.makeEmptyRowsModel(n);
        }
        STMTreeNode sTMTreeNode = n.findFirstNonErrorChild();
        STMTreeTermNode firstTermChild = sTMTreeNode instanceof STMTreeTermNode ? (t = (STMTreeTermNode)sTMTreeNode) : null;
        SQLQueryLexicalScope sQLQueryLexicalScope = rightTableScope = firstTermChild != null ? new SQLQueryLexicalScope() : null;
        if (firstTermChild != null) {
            rightTableScope.setInterval(Interval.of((int)(firstTermChild.getRealInterval().b + 1), (int)Integer.MAX_VALUE));
        }
        SubsourcesMap subsources = new SubsourcesMap(cc, n);
        STMTreeNode firstChild = n.findFirstChildOfName(STMKnownRuleNames.tableReference);
        List restChilds = n.findChildrenOfName(STMKnownRuleNames.fromClauseTerm);
        SQLQueryRowsSourceModel source = subsources.getOrEmpty(firstChild);
        for (STMTreeNode childNode : restChilds) {
            SQLQueryRowsSourceModel nextSource = subsources.getOrEmpty(childNode);
            if (nextSource == null) continue;
            Interval range = Interval.of((int)n.getRealInterval().a, (int)childNode.getRealInterval().b);
            boolean isLateral = childNode.findFirstChildOfName(STMKnownRuleNames.LATERAL_TERM) != null;
            source = new SQLQueryRowsCrossJoinModel(range, childNode, source, nextSource, rightTableScope, isLateral);
        }
        return source;
    }, STMKnownRuleNames.querySpecification, (n, cc, r) -> SQLQueryRowsProjectionModel.recognize(n, cc, r), STMKnownRuleNames.selectStatementSingleRow, (n, cc, r) -> SQLQuerySelectIntoModel.recognize(n, cc, r), STMKnownRuleNames.nonjoinedTableReference, (n, cc, r) -> {
        STMTreeNode callNode = n.findFirstChildOfName(STMKnownRuleNames.functionCallExpression);
        STMTreeNode tableNode = n.findFirstChildOfName(STMKnownRuleNames.tableName);
        SQLQueryRowsSourceModel source = !cc.isEmpty() ? (SQLQueryRowsSourceModel)cc.getFirst() : (tableNode != null ? r.collectTableReference(tableNode, false) : (callNode != null ? new SQLQueryRowsTableProcModel(r.collectFunctionCall(callNode, null, true)) : SQLQueryExpressionMapper.makeEmptyRowsModel(n)));
        STMTreeNode correlationSpecNode = n.findLastChildOfName(STMKnownRuleNames.correlationSpecification);
        if (correlationSpecNode != null) {
            SQLQuerySymbolEntry correlationName;
            STMTreeNode correlationNameNode = correlationSpecNode.findFirstChildOfName(STMKnownRuleNames.correlationName);
            SQLQuerySymbolEntry sQLQuerySymbolEntry = correlationName = correlationNameNode == null ? null : r.collectIdentifier(correlationNameNode, null);
            if (correlationName != null) {
                List<SQLQuerySymbolEntry> correlationColumNames = r.collectColumnNameList(correlationSpecNode);
                source = new SQLQueryRowsCorrelatedSourceModel(n, source, correlationName, correlationColumNames);
                SQLQueryLexicalScope aliasesScope = new SQLQueryLexicalScope(correlationColumNames.size() + 1);
                aliasesScope.registerItem(correlationName);
                correlationColumNames.forEach(aliasesScope::registerItem);
                source.registerLexicalScope(aliasesScope);
            }
        }
        return source;
    }, STMKnownRuleNames.explicitTable, (n, cc, r) -> r.collectTableReference(n, false), STMKnownRuleNames.tableValueConstructor, (n, cc, r) -> {
        List rowNodes = n.findChildrenOfName(STMKnownRuleNames.rowValueConstructor);
        boolean hasErrors = false;
        LinkedList<List<SQLQueryValueExpression>> rows = new LinkedList<List<SQLQueryValueExpression>>();
        for (STMTreeNode rowNode : rowNodes) {
            List<Object> values;
            STMTreeNode valueNode = rowNode.findFirstChildOfName(STMKnownRuleNames.rowValueConstructorElement);
            if (valueNode != null) {
                hasErrors |= rowNode.hasErrorChildren() || valueNode.hasErrorChildren();
                STMTreeNode actualValueNode = valueNode.findFirstNonErrorChild();
                values = actualValueNode == null ? Collections.emptyList() : List.of(r.collectValueExpression(actualValueNode, null));
                rows.addLast(values);
                continue;
            }
            STMTreeNode rowValuesNode = rowNode.findFirstChildOfName(STMKnownRuleNames.rowValueConstructorList);
            if (rowValuesNode != null) {
                values = rowValuesNode.findChildrenOfName(STMKnownRuleNames.rowValueConstructorElement).stream().map(en -> {
                    STMTreeNode vn = en.findFirstNonErrorChild();
                    return vn != null ? r.collectValueExpression(vn, null) : new SQLQueryValueFlattenedExpression((STMTreeNode)en, Collections.emptyList());
                }).toList();
                hasErrors |= rowNode.hasErrorChildren() || rowValuesNode.hasErrorChildren();
                rows.addLast(values);
                continue;
            }
            if (!cc.isEmpty()) continue;
            rows.addLast(Collections.emptyList());
        }
        return new SQLQueryRowsTableValueModel(n, rows, hasErrors);
    });

    public SQLQueryExpressionMapper(@NotNull SQLQueryModelRecognizer recognizer) {
        super(SQLQueryRowsSourceModel.class, queryExpressionSubtreeNodeNames, translations, recognizer);
    }

    private static STMTreeNode findImmediateChild(STMTreeNode subroot, STMTreeNode deeperChild) {
        STMTreeNode current = deeperChild;
        STMTreeNode parent = current.getParentNode();
        while (parent != subroot && parent != null) {
            current = parent;
            parent = current.getParentNode();
        }
        return current;
    }

    public static SQLQueryRowsSourceModel makeEmptyRowsModel(STMTreeNode n) {
        return new SQLQueryRowsTableValueModel(n, Collections.emptyList(), true);
    }

    private static class SubsourcesMap {
        private final Map<STMTreeNode, SQLQueryRowsSourceModel> subsourceByNode;

        public SubsourcesMap(@NotNull List<SQLQueryRowsSourceModel> subqueries, @NotNull STMTreeNode subroot) {
            this.subsourceByNode = new HashMap<STMTreeNode, SQLQueryRowsSourceModel>(subqueries.size());
            for (SQLQueryRowsSourceModel subquery : subqueries) {
                STMTreeNode subrootChild = SQLQueryExpressionMapper.findImmediateChild(subroot, subquery.getSyntaxNode());
                this.subsourceByNode.put(subrootChild, subquery);
            }
        }

        @Nullable
        public SQLQueryRowsSourceModel getOrNull(@NotNull STMTreeNode subrootsChild) {
            return this.subsourceByNode.get(subrootsChild);
        }

        @NotNull
        public SQLQueryRowsSourceModel getOrEmpty(STMTreeNode subrootsChild) {
            SQLQueryRowsSourceModel source = this.subsourceByNode.get(subrootsChild);
            if (source == null) {
                source = SQLQueryExpressionMapper.makeEmptyRowsModel(subrootsChild);
            }
            return source;
        }
    }
}

