/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.acl;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.access.DBAPrivilege;
import org.jkiss.dbeaver.model.access.DBAPrivilegeOwner;
import org.jkiss.dbeaver.model.access.DBAPrivilegeType;
import org.jkiss.dbeaver.model.edit.DBECommand;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.editors.acl.ObjectACLManager;
import org.jkiss.dbeaver.ui.editors.acl.internal.ACLMessages;

public class ACLCommandChangePrivilege
extends DBECommandAbstract<DBAPrivilegeOwner> {
    private ObjectACLManager aclManager;
    private boolean grant;
    private DBAPrivilege privilege;
    private DBAPrivilegeType[] privilegeTypes;

    public ACLCommandChangePrivilege(ObjectACLManager aclManager, DBAPrivilegeOwner user, boolean grant, DBAPrivilege privilege, DBAPrivilegeType[] privilegeTypes) {
        super((DBPObject)user, grant ? ACLMessages.edit_command_grant_privilege_action_grant_privilege : ACLMessages.edit_command_grant_privilege_action_revoke_privilege);
        this.aclManager = aclManager;
        this.grant = grant;
        this.privilege = privilege;
        this.privilegeTypes = privilegeTypes;
    }

    public void updateModel() {
    }

    @NotNull
    public DBEPersistAction[] getPersistActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull Map<String, Object> options) {
        DBAPrivilegeOwner object = (DBAPrivilegeOwner)this.getObject();
        String grantScript = this.aclManager.generatePermissionChangeScript(monitor, object, this.grant, this.privilege, this.privilegeTypes, options);
        return new DBEPersistAction[]{new SQLDatabasePersistAction(ACLMessages.edit_command_grant_privilege_action_grant_privilege, grantScript)};
    }

    @NotNull
    public DBECommand<?> merge(@NotNull DBECommand<?> prevCommand, @NotNull Map<Object, Object> userParams) {
        if (prevCommand instanceof ACLCommandChangePrivilege) {
            ACLCommandChangePrivilege prevGrant = (ACLCommandChangePrivilege)prevCommand;
            if (prevGrant.privilege == this.privilege && prevGrant.privilegeTypes == this.privilegeTypes) {
                if (prevGrant.grant == this.grant) {
                    return prevCommand;
                }
                return null;
            }
        }
        return super.merge(prevCommand, userParams);
    }
}

