/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.EditorMessages;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.eclipse.ui.texteditor.StatusLineContributionItem;

public class BasicTextEditorActionContributor
extends EditorActionBarContributor {
    private static final String[] ACTIONS = new String[]{ITextEditorActionConstants.UNDO, ITextEditorActionConstants.REDO, ITextEditorActionConstants.CUT, ITextEditorActionConstants.COPY, ITextEditorActionConstants.PASTE, ITextEditorActionConstants.DELETE, ITextEditorActionConstants.SELECT_ALL, ITextEditorActionConstants.FIND, ITextEditorActionConstants.PRINT, ITextEditorActionConstants.PROPERTIES, ITextEditorActionConstants.REVERT};
    private static final StatusFieldDef[] STATUS_FIELD_DEFS = new StatusFieldDef[]{new StatusFieldDef("findField", null, false, EditorMessages.Editor_FindIncremental_reverse_name.length() + 15), new StatusFieldDef("ElementState", null, true, 20), new StatusFieldDef("InputMode", "org.eclipse.ui.edit.text.toggleOverwrite", true, 19), new StatusFieldDef("InputPosition", "GotoLine", true, 19)};
    private IEditorPart fActiveEditorPart;
    private final RetargetTextEditorAction fFindNext = new RetargetTextEditorAction(EditorMessages.getBundleForConstructedKeys(), "Editor.FindNext.");
    private final RetargetTextEditorAction fFindPrevious;
    private final RetargetTextEditorAction fIncrementalFind;
    private final RetargetTextEditorAction fIncrementalFindReverse;
    private final RetargetTextEditorAction fGotoLine;
    private final RetargetTextEditorAction fHippieCompletion;
    private final Map<StatusFieldDef, StatusLineContributionItem> fStatusFields;

    public BasicTextEditorActionContributor() {
        this.fFindNext.setActionDefinitionId("org.eclipse.ui.edit.findNext");
        this.fFindPrevious = new RetargetTextEditorAction(EditorMessages.getBundleForConstructedKeys(), "Editor.FindPrevious.");
        this.fFindPrevious.setActionDefinitionId("org.eclipse.ui.edit.findPrevious");
        this.fIncrementalFind = new RetargetTextEditorAction(EditorMessages.getBundleForConstructedKeys(), "Editor.FindIncremental.");
        this.fIncrementalFind.setActionDefinitionId("org.eclipse.ui.edit.findIncremental");
        this.fIncrementalFindReverse = new RetargetTextEditorAction(EditorMessages.getBundleForConstructedKeys(), "Editor.FindIncrementalReverse.");
        this.fIncrementalFindReverse.setActionDefinitionId("org.eclipse.ui.edit.findIncrementalReverse");
        this.fGotoLine = new RetargetTextEditorAction(EditorMessages.getBundleForConstructedKeys(), "Editor.GotoLine.");
        this.fGotoLine.setActionDefinitionId("org.eclipse.ui.edit.text.goto.line");
        this.fHippieCompletion = new RetargetTextEditorAction(EditorMessages.getBundleForConstructedKeys(), "Editor.HippieCompletion.");
        this.fHippieCompletion.setActionDefinitionId("org.eclipse.ui.edit.text.hippieCompletion");
        this.fStatusFields = new HashMap<StatusFieldDef, StatusLineContributionItem>(3);
        StatusFieldDef[] statusFieldDefArray = STATUS_FIELD_DEFS;
        int n = STATUS_FIELD_DEFS.length;
        int n2 = 0;
        while (n2 < n) {
            StatusFieldDef fieldDef = statusFieldDefArray[n2];
            this.fStatusFields.put(fieldDef, new StatusLineContributionItem(fieldDef.category, fieldDef.visible, fieldDef.widthInChars));
            ++n2;
        }
    }

    protected final IEditorPart getActiveEditorPart() {
        return this.fActiveEditorPart;
    }

    protected final IAction getAction(ITextEditor editor, String actionId) {
        return editor == null || actionId == null ? null : editor.getAction(actionId);
    }

    private void doSetActiveEditor(IEditorPart part) {
        Object element;
        ITextEditor i;
        if (this.fActiveEditorPart == part) {
            return;
        }
        IEditorPart iEditorPart = this.fActiveEditorPart;
        if (iEditorPart instanceof ITextEditorExtension) {
            ITextEditorExtension extension = (ITextEditorExtension)iEditorPart;
            StatusFieldDef[] statusFieldDefArray = STATUS_FIELD_DEFS;
            int n = STATUS_FIELD_DEFS.length;
            int n2 = 0;
            while (n2 < n) {
                StatusFieldDef element2 = statusFieldDefArray[n2];
                extension.setStatusField(null, element2.category);
                ++n2;
            }
        }
        this.fActiveEditorPart = part;
        ITextEditor editor = part instanceof ITextEditor ? (i = (ITextEditor)part) : null;
        IActionBars actionBars = this.getActionBars();
        Object[] objectArray = ACTIONS;
        int n = ACTIONS.length;
        int n3 = 0;
        while (n3 < n) {
            element = objectArray[n3];
            actionBars.setGlobalActionHandler((String)element, this.getAction(editor, (String)element));
            ++n3;
        }
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowWhitespaceCharacters", this.getAction(editor, "ShowWhitespaceCharacters"));
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.toggleBlockSelectionMode", this.getAction(editor, "BlockSelectionMode"));
        if (editor instanceof AbstractTextEditor && ((AbstractTextEditor)editor).isWordWrapSupported()) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.toggleWordWrap", this.getAction(editor, "WordWrap"));
        }
        this.fFindNext.setAction(this.getAction(editor, "FindNext"));
        this.fFindPrevious.setAction(this.getAction(editor, "FindPrevious"));
        this.fIncrementalFind.setAction(this.getAction(editor, "FindIncremental"));
        this.fIncrementalFindReverse.setAction(this.getAction(editor, "FindIncrementalReverse"));
        this.fGotoLine.setAction(this.getAction(editor, "GotoLine"));
        this.fHippieCompletion.setAction(this.getAction(editor, "HIPPIE_COMPLETION"));
        objectArray = STATUS_FIELD_DEFS;
        n = STATUS_FIELD_DEFS.length;
        n3 = 0;
        while (n3 < n) {
            element = objectArray[n3];
            IEditorPart iEditorPart2 = this.fActiveEditorPart;
            if (iEditorPart2 instanceof ITextEditorExtension) {
                ITextEditorExtension extension = (ITextEditorExtension)iEditorPart2;
                StatusLineContributionItem statusField = this.fStatusFields.get(element);
                statusField.setActionHandler(this.getAction(editor, ((StatusFieldDef)element).actionId));
                extension.setStatusField(statusField, ((StatusFieldDef)element).category);
            }
            ++n3;
        }
    }

    public void setActiveEditor(IEditorPart part) {
        this.doSetActiveEditor(part);
    }

    public void contributeToMenu(IMenuManager menu) {
        IMenuManager navigateMenu;
        IMenuManager editMenu = menu.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.prependToGroup("find.ext", (IAction)this.fIncrementalFindReverse);
            editMenu.prependToGroup("find.ext", (IAction)this.fIncrementalFind);
            editMenu.prependToGroup("find.ext", (IAction)this.fFindPrevious);
            editMenu.prependToGroup("find.ext", (IAction)this.fFindNext);
            this.addOrInsert((IContributionManager)editMenu, (IContributionItem)new Separator("group.open"));
            this.addOrInsert((IContributionManager)editMenu, (IContributionItem)new Separator("group.information"));
            this.addOrInsert((IContributionManager)editMenu, (IContributionItem)new Separator("group.assist"));
            this.addOrInsert((IContributionManager)editMenu, (IContributionItem)new Separator("group.generate"));
            this.addOrInsert((IContributionManager)editMenu, (IContributionItem)new Separator("additions"));
            editMenu.appendToGroup("group.assist", (IAction)this.fHippieCompletion);
        }
        if ((navigateMenu = menu.findMenuUsingPath("navigate")) != null) {
            navigateMenu.appendToGroup("additions", (IAction)this.fGotoLine);
        }
    }

    private void addOrInsert(IContributionManager menu, IContributionItem item) {
        String id = item.getId();
        if (menu.find(id) == null) {
            menu.add(item);
        } else {
            menu.insertAfter(id, item);
        }
    }

    public void contributeToStatusLine(IStatusLineManager statusLineManager) {
        super.contributeToStatusLine(statusLineManager);
        StatusFieldDef[] statusFieldDefArray = STATUS_FIELD_DEFS;
        int n = STATUS_FIELD_DEFS.length;
        int n2 = 0;
        while (n2 < n) {
            StatusFieldDef element = statusFieldDefArray[n2];
            statusLineManager.add((IContributionItem)this.fStatusFields.get(element));
            ++n2;
        }
    }

    public void dispose() {
        this.doSetActiveEditor(null);
        super.dispose();
    }

    private static class StatusFieldDef {
        private final String category;
        private final String actionId;
        private final boolean visible;
        private final int widthInChars;

        private StatusFieldDef(String category, String actionId, boolean visible, int widthInChars) {
            Assert.isNotNull((Object)category);
            this.category = category;
            this.actionId = actionId;
            this.visible = visible;
            this.widthInChars = widthInChars;
        }
    }
}

