/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;

public class PrefPagePostgreSQL
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.postgresql.general";
    private Button showNonDefault;
    private Button showTemplates;
    private Button showUnavailable;
    private Button showDatabaseStatistics;
    private Button readAllDataTypes;
    private Button readKeysWithColumns;
    private Button replaceLegacyTimezone;
    private Combo ddPlainBehaviorCombo;
    private Combo ddTagBehaviorCombo;

    public PrefPagePostgreSQL() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite cfgGroup = UIUtils.createComposite((Composite)parent, (int)1);
        cfgGroup.setLayoutData((Object)new GridData(1808));
        DBPPreferenceStore globalPrefs = DBWorkbench.getPlatform().getPreferenceStore();
        Composite secureGroup = UIUtils.createTitledComposite((Composite)cfgGroup, (String)PostgreMessages.dialog_setting_connection_settings, (int)2, (int)32);
        this.showNonDefault = UIUtils.createCheckbox((Composite)secureGroup, (String)PostgreMessages.dialog_setting_connection_nondefaultDatabase, (String)PostgreMessages.dialog_setting_connection_nondefaultDatabase_tip, (boolean)globalPrefs.getBoolean("@dbeaver-show-non-default-db@"), (int)2);
        this.showNonDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPagePostgreSQL.this.setCheckboxesState();
            }
        });
        this.showTemplates = UIUtils.createCheckbox((Composite)secureGroup, (String)PostgreMessages.dialog_setting_connection_show_templates, (String)PostgreMessages.dialog_setting_connection_show_templates_tip, (boolean)globalPrefs.getBoolean("@dbeaver-show-template-db@"), (int)2);
        this.showUnavailable = UIUtils.createCheckbox((Composite)secureGroup, (String)PostgreMessages.dialog_setting_connection_show_not_available_for_conn, (String)PostgreMessages.dialog_setting_connection_show_not_available_for_conn_tip, (boolean)globalPrefs.getBoolean("@dbeaver-show-unavailable-db@"), (int)2);
        this.setCheckboxesState();
        this.showDatabaseStatistics = UIUtils.createCheckbox((Composite)secureGroup, (String)PostgreMessages.dialog_setting_connection_database_statistics, (String)PostgreMessages.dialog_setting_connection_database_statistics_tip, (boolean)globalPrefs.getBoolean("show-database-statistics"), (int)2);
        this.readAllDataTypes = UIUtils.createCheckbox((Composite)secureGroup, (String)PostgreMessages.dialog_setting_connection_read_all_data_types, (String)PostgreMessages.dialog_setting_connection_read_all_data_types_tip, (boolean)globalPrefs.getBoolean("@dbeaver-read-all-data-types-db@"), (int)2);
        this.readKeysWithColumns = UIUtils.createCheckbox((Composite)secureGroup, (String)PostgreMessages.dialog_setting_connection_read_keys_with_columns, (String)PostgreMessages.dialog_setting_connection_read_keys_with_columns_tip, (boolean)globalPrefs.getBoolean("read-keys-with-columns"), (int)2);
        this.replaceLegacyTimezone = UIUtils.createCheckbox((Composite)secureGroup, (String)PostgreMessages.dialog_setting_connection_replace_legacy_timezone, (String)PostgreMessages.dialog_setting_connection_replace_legacy_timezone_tip, (boolean)globalPrefs.getBoolean("replace-legacy-timezone"), (int)2);
        secureGroup = UIUtils.createTitledComposite((Composite)cfgGroup, (String)PostgreMessages.dialog_setting_group_sql, (int)2, (int)32);
        this.ddPlainBehaviorCombo = UIUtils.createLabelCombo((Composite)secureGroup, (String)PostgreMessages.dialog_setting_sql_dd_plain_label, (String)PostgreMessages.dialog_setting_sql_dd_plain_tip, (int)12);
        this.ddPlainBehaviorCombo.add(PostgreMessages.dialog_setting_sql_dd_string);
        this.ddPlainBehaviorCombo.add(PostgreMessages.dialog_setting_sql_dd_code_block);
        this.ddTagBehaviorCombo = UIUtils.createLabelCombo((Composite)secureGroup, (String)PostgreMessages.dialog_setting_sql_dd_tag_label, (String)PostgreMessages.dialog_setting_sql_dd_tag_tip, (int)12);
        this.ddTagBehaviorCombo.add(PostgreMessages.dialog_setting_sql_dd_string);
        this.ddTagBehaviorCombo.add(PostgreMessages.dialog_setting_sql_dd_code_block);
        this.ddPlainBehaviorCombo.select(globalPrefs.getBoolean("postgresql.dd.plain.string") ? 0 : 1);
        this.ddTagBehaviorCombo.select(globalPrefs.getBoolean("postgresql.dd.tag.string") ? 0 : 1);
        return cfgGroup;
    }

    private void setCheckboxesState() {
        boolean enable = this.showNonDefault.getSelection();
        if (!enable) {
            this.showUnavailable.setSelection(false);
            this.showTemplates.setSelection(false);
        }
        this.showUnavailable.setEnabled(enable);
        this.showTemplates.setEnabled(enable);
    }

    public boolean performOk() {
        DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        preferenceStore.setValue("@dbeaver-show-non-default-db@", String.valueOf(this.showNonDefault.getSelection()));
        preferenceStore.setValue("@dbeaver-show-template-db@", String.valueOf(this.showTemplates.getSelection()));
        preferenceStore.setValue("@dbeaver-show-unavailable-db@", String.valueOf(this.showUnavailable.getSelection()));
        preferenceStore.setValue("show-database-statistics", String.valueOf(this.showDatabaseStatistics.getSelection()));
        preferenceStore.setValue("@dbeaver-read-all-data-types-db@", String.valueOf(this.readAllDataTypes.getSelection()));
        preferenceStore.setValue("read-keys-with-columns", String.valueOf(this.readKeysWithColumns.getSelection()));
        preferenceStore.setValue("replace-legacy-timezone", String.valueOf(this.replaceLegacyTimezone.getSelection()));
        preferenceStore.setValue("postgresql.dd.plain.string", this.ddPlainBehaviorCombo.getSelectionIndex() == 0);
        preferenceStore.setValue("postgresql.dd.tag.string", this.ddTagBehaviorCombo.getSelectionIndex() == 0);
        return super.performOk();
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.showNonDefault.setSelection(store.getDefaultBoolean("@dbeaver-show-non-default-db@"));
        this.showTemplates.setSelection(store.getDefaultBoolean("@dbeaver-show-template-db@"));
        this.showUnavailable.setSelection(store.getDefaultBoolean("@dbeaver-show-unavailable-db@"));
        this.showDatabaseStatistics.setSelection(store.getDefaultBoolean("show-database-statistics"));
        this.readAllDataTypes.setSelection(store.getDefaultBoolean("@dbeaver-read-all-data-types-db@"));
        this.readKeysWithColumns.setSelection(store.getDefaultBoolean("read-keys-with-columns"));
        this.replaceLegacyTimezone.setSelection(store.getDefaultBoolean("replace-legacy-timezone"));
        this.ddPlainBehaviorCombo.select(store.getDefaultInt("postgresql.dd.plain.string"));
        this.ddTagBehaviorCombo.select(store.getDefaultInt("postgresql.dd.tag.string"));
        this.setCheckboxesState();
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }
}

