/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.app;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.impl.app.ApplicationRegistry;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;
import org.osgi.framework.FrameworkUtil;

public abstract class AbstractApplication
implements IApplication,
DBPApplication {
    private static final Log log = Log.getLog(AbstractApplication.class);
    public static final Integer EXIT_ERROR_UNSPECIFIED = 1;
    private static DBPApplication INSTANCE;
    private String applicationRunId;
    private final long applicationStartTime = System.currentTimeMillis();

    protected AbstractApplication() {
        if (INSTANCE != null) {
            log.error("Multiple application instances created: " + INSTANCE.getClass().getName() + ", " + this.getClass().getName());
        }
        INSTANCE = this;
    }

    public static DBPApplication getInstance() {
        if (INSTANCE == null) {
            DBPApplication instance = null;
            try {
                instance = ApplicationRegistry.getInstance().getApplication().getInstance();
            }
            catch (Throwable e) {
                log.error(e);
            }
            if (instance == null) {
                throw new IllegalStateException("No DBeaver application found");
            }
            INSTANCE = instance;
        }
        return INSTANCE;
    }

    @Override
    @NotNull
    public Map<String, String> getAdditionalApplicationProperties() {
        return Map.of();
    }

    @Override
    public boolean isStandalone() {
        return true;
    }

    @Override
    public boolean isPrimaryInstance() {
        return true;
    }

    @Override
    public boolean isHeadlessMode() {
        return false;
    }

    @Override
    public boolean isExclusiveMode() {
        return false;
    }

    @Override
    public boolean isMultiuser() {
        return false;
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public boolean isDetachedProcess() {
        return false;
    }

    @Override
    @NotNull
    public String getApplicationRunId() {
        if (this.applicationRunId == null) {
            this.applicationRunId = UUID.randomUUID().toString();
        }
        return this.applicationRunId;
    }

    @Override
    public long getApplicationStartTime() {
        return this.applicationStartTime;
    }

    @Override
    public String getInfoDetails() {
        return "N/A";
    }

    @Override
    @Nullable
    public String getProductProperty(@NotNull String propName) {
        return Platform.getProduct().getProperty(propName);
    }

    @Override
    public boolean hasProductFeature(@NotNull String featureName) {
        return switch (featureName) {
            case "multi-fs" -> false;
            default -> true;
        };
    }

    @NotNull
    public Object start(IApplicationContext context) throws Exception {
        return EXIT_OK;
    }

    public void stop() {
    }

    protected void initializeApplicationServices() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader instanceof BundleReference) {
            BundleReference br = (BundleReference)classLoader;
            BundleContext bundleContext = br.getBundle().getBundleContext();
            if (bundleContext == null) {
                bundleContext = FrameworkUtil.getBundle(DBPApplication.class).getBundleContext();
            }
            this.registerService(bundleContext, DBPPlatform.class, this.getPlatformClass());
            this.registerService(bundleContext, DBPPlatformUI.class, this.getPlatformUIClass());
        } else {
            log.error("Cannot initialize application services in non-OSGI context");
        }
    }

    protected <T> void registerService(BundleContext bundleContext, Class<T> serviceInt, Class<? extends T> serviceImplClass) {
        if (serviceImplClass == null) {
            return;
        }
        try {
            Constructor<T> constructor = serviceImplClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            T serviceImpl = constructor.newInstance(new Object[0]);
            bundleContext.registerService(serviceInt, serviceImpl, null);
        }
        catch (Throwable e) {
            log.error("Error instantiating service '" + serviceInt.getName() + "'", e);
        }
    }
}

