/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.internal.ui.actions.ITeamRunnableContext;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class ProgressDialogRunnableContext
implements ITeamRunnableContext {
    private IRunnableContext runnableContext;
    private ISchedulingRule schedulingRule;
    private boolean postponeBuild;

    public void setPostponeBuild(boolean postponeBuild) {
        this.postponeBuild = postponeBuild;
    }

    public void setSchedulingRule(ISchedulingRule schedulingRule) {
        this.schedulingRule = schedulingRule;
    }

    public void setRunnableContext(IRunnableContext runnableContext) {
        this.runnableContext = runnableContext;
    }

    @Override
    public void run(IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.getRunnableContext().run(true, true, this.wrapRunnable(runnable));
    }

    private IRunnableContext getRunnableContext() {
        if (this.runnableContext == null) {
            return (fork, cancelable, runnable) -> {
                IProgressService manager = PlatformUI.getWorkbench().getProgressService();
                manager.busyCursorWhile(runnable);
            };
        }
        return this.runnableContext;
    }

    private IRunnableWithProgress wrapRunnable(IRunnableWithProgress runnable) {
        return monitor -> {
            try {
                if (this.schedulingRule == null && !this.postponeBuild) {
                    runnable.run(monitor);
                } else {
                    Exception[] exception = new Exception[1];
                    ResourcesPlugin.getWorkspace().run(pm -> {
                        try {
                            runnable.run(pm);
                        }
                        catch (InvocationTargetException e1) {
                            exceptionArray[0] = e1;
                        }
                        catch (InterruptedException e2) {
                            exceptionArray[0] = e2;
                        }
                    }, this.schedulingRule, 0, monitor);
                    if (exception[0] != null) {
                        if (exception[0] instanceof InvocationTargetException) {
                            throw (InvocationTargetException)exception[0];
                        }
                        if (exception[0] instanceof InterruptedException) {
                            throw (InterruptedException)exception[0];
                        }
                    }
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        };
    }
}

