/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs.lock;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.fs.lock.FileLock;
import org.jkiss.dbeaver.model.fs.lock.FileLockInfo;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.IOUtils;

public class FileLockController {
    private static final Log log = Log.getLog(FileLockController.class);
    private static final long DEFAULT_MAX_LOCK_TIME = Duration.ofMinutes(1L).toMillis();
    private static final int CHECK_PERIOD = 10;
    private static final String LOCK_META_FOLDER = ".locks";
    private static final String LOCK_FILE_EXTENSION = ".lock";
    private final Gson gson = new Gson();
    private final Path lockFolderPath;
    private final String applicationId;
    private final long maxLockTime;

    public FileLockController(@NotNull String applicationId) throws DBException {
        this(applicationId, DEFAULT_MAX_LOCK_TIME, GeneralUtils.getMetadataFolder());
    }

    public FileLockController(@NotNull String applicationId, @NotNull Path metadataFolder) throws DBException {
        this(applicationId, DEFAULT_MAX_LOCK_TIME, metadataFolder);
    }

    public FileLockController(@NotNull String applicationId, long maxLockTime, @NotNull Path metadataFolder) throws DBException {
        this.lockFolderPath = metadataFolder.resolve(LOCK_META_FOLDER);
        this.applicationId = applicationId;
        this.maxLockTime = maxLockTime;
    }

    @NotNull
    public FileLock lock(@NotNull String lockFileName, @NotNull String operationName) throws DBException {
        Class<FileLockController> clazz = FileLockController.class;
        synchronized (FileLockController.class) {
            try {
                FileLockInfo lockInfo = new FileLockInfo.Builder(UUID.randomUUID().toString()).setApplicationId(this.applicationId).setOperationName(operationName).setOperationStartTime(System.currentTimeMillis()).build();
                Path lockFilePath = this.getLockFilePath(lockFileName);
                if (!IOUtils.isFileFromDefaultFS((Path)this.lockFolderPath)) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return new FileLock(lockFilePath);
                }
                this.createLockFolderIfNeeded();
                this.createLockFile(lockFilePath, lockInfo);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return new FileLock(lockFilePath);
            }
            catch (Exception e) {
                throw new DBException("Failed to lock file: " + lockFileName, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FileLock lockIfNotLocked(@NotNull String lockFileName, @NotNull String operationName) throws DBException {
        Class<FileLockController> clazz = FileLockController.class;
        synchronized (FileLockController.class) {
            block4: {
                if (!this.isLocked(this.getLockFilePath(lockFileName))) break block4;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.lock(lockFileName, operationName);
        }
    }

    protected boolean isLocked(@NotNull Path lockFilePath) {
        return Files.exists(lockFilePath, new LinkOption[0]);
    }

    public boolean isFileLocked(@NotNull String lockFileName) {
        Path projectLockFilePath = this.getLockFilePath(lockFileName);
        return this.isLocked(projectLockFilePath);
    }

    private void createLockFile(@NotNull Path lockFile, @NotNull FileLockInfo lockInfo) throws DBException, InterruptedException {
        boolean lockFileCreated = false;
        while (!lockFileCreated) {
            if (Files.exists(lockFile, new LinkOption[0])) {
                this.awaitUnlock(lockFile);
            }
            try {
                Files.createFile(lockFile, new FileAttribute[0]);
                lockFileCreated = true;
            }
            catch (IOException e) {
                if (Files.exists(lockFile, new LinkOption[0])) {
                    log.info("Looks like file was locked by another rm instance at the same time");
                    continue;
                }
                throw new DBException("Failed to create lock file: " + String.valueOf(lockFile), e);
            }
            try {
                Files.write(lockFile, this.gson.toJson((Object)lockInfo).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                log.error("Failed to write lock info, unlock: " + String.valueOf(lockFile));
                try {
                    Files.deleteIfExists(lockFile);
                }
                catch (IOException ex) {
                    throw new DBException("Failed to remove invalid lock file: " + String.valueOf(lockFile), ex);
                }
                throw new DBException("Failed to lock: " + String.valueOf(lockFile.getFileName()), e);
            }
        }
    }

    protected void awaitUnlock(@NotNull Path lockFile) throws InterruptedException, DBException {
        if (!this.isLocked(lockFile)) {
            return;
        }
        this.awaitingUnlock(lockFile);
    }

    protected void awaitingUnlock(@NotNull Path lockFile) throws DBException, InterruptedException {
        log.info("Waiting for a file to be unlocked: " + String.valueOf(lockFile));
        FileLockInfo originalLockInfo = this.readLockInfo(lockFile);
        boolean fileUnlocked = originalLockInfo == null;
        long maxIterations = this.maxLockTime / 10L;
        int currentCheckCount = 0;
        while (!fileUnlocked) {
            boolean bl = fileUnlocked = !this.isLocked(lockFile);
            if ((long)currentCheckCount >= maxIterations || fileUnlocked) break;
            if (originalLockInfo != null && originalLockInfo.isBlank()) {
                originalLockInfo = this.readLockInfo(lockFile);
            }
            ++currentCheckCount;
            Thread.sleep(10L);
        }
        if (fileUnlocked) {
            return;
        }
        FileLockInfo currentLockInfo = this.readLockInfo(lockFile);
        if (currentLockInfo == null) {
            return;
        }
        if (originalLockInfo != null && originalLockInfo.getOperationId().equals(currentLockInfo.getOperationId())) {
            this.forceUnlock(lockFile);
        } else {
            this.awaitUnlock(lockFile);
        }
    }

    protected void forceUnlock(Path projectLockFile) {
        log.warn("File has not been unlocked within the expected period, force unlock");
        try {
            Files.deleteIfExists(projectLockFile);
        }
        catch (IOException e) {
            log.error(e);
        }
    }

    @Nullable
    private FileLockInfo readLockInfo(@NotNull Path lockFile) {
        if (Files.notExists(lockFile, new LinkOption[0])) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader reader = Files.newBufferedReader(lockFile, StandardCharsets.UTF_8);){
                return (FileLockInfo)this.gson.fromJson((Reader)reader, FileLockInfo.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            if (!this.isLocked(lockFile)) {
                return null;
            }
            log.warn("Failed to read lock file info, but lock file still exist: " + String.valueOf(lockFile));
            return FileLockInfo.emptyLock();
        }
    }

    @NotNull
    private Path getLockFilePath(@NotNull String lockFileName) {
        return this.lockFolderPath.resolve(lockFileName + LOCK_FILE_EXTENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLockFolderIfNeeded() throws IOException {
        Class<FileLockController> clazz = FileLockController.class;
        synchronized (FileLockController.class) {
            if (Files.notExists(this.lockFolderPath, new LinkOption[0])) {
                Files.createDirectories(this.lockFolderPath, new FileAttribute[0]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

