// Code generated by 'go run genfiles.go'; DO NOT EDIT.

//go:build goexperiment.simd

// This file contains functions testing unary simd methods.
// Each function in this file is specialized for a
// particular simd type <BaseType><Width>x<Count>.

package simd_test

import (
	"simd/archsimd"
	"testing"
)

// testInt8x16Unary tests the simd unary method f against the expected behavior generated by want
func testInt8x16Unary(t *testing.T, f func(_ archsimd.Int8x16) archsimd.Int8x16, want func(_ []int8) []int8) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]int8, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8Unary tests the simd unary method f against the expected behavior generated by want
func testInt16x8Unary(t *testing.T, f func(_ archsimd.Int16x8) archsimd.Int16x8, want func(_ []int16) []int16) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]int16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4Unary tests the simd unary method f against the expected behavior generated by want
func testInt32x4Unary(t *testing.T, f func(_ archsimd.Int32x4) archsimd.Int32x4, want func(_ []int32) []int32) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x2Unary tests the simd unary method f against the expected behavior generated by want
func testInt64x2Unary(t *testing.T, f func(_ archsimd.Int64x2) archsimd.Int64x2, want func(_ []int64) []int64) {
	n := 2
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x2Slice(x)
		g := make([]int64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16Unary tests the simd unary method f against the expected behavior generated by want
func testUint8x16Unary(t *testing.T, f func(_ archsimd.Uint8x16) archsimd.Uint8x16, want func(_ []uint8) []uint8) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]uint8, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8Unary tests the simd unary method f against the expected behavior generated by want
func testUint16x8Unary(t *testing.T, f func(_ archsimd.Uint16x8) archsimd.Uint16x8, want func(_ []uint16) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4Unary tests the simd unary method f against the expected behavior generated by want
func testUint32x4Unary(t *testing.T, f func(_ archsimd.Uint32x4) archsimd.Uint32x4, want func(_ []uint32) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x2Unary tests the simd unary method f against the expected behavior generated by want
func testUint64x2Unary(t *testing.T, f func(_ archsimd.Uint64x2) archsimd.Uint64x2, want func(_ []uint64) []uint64) {
	n := 2
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x2Slice(x)
		g := make([]uint64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x4Unary tests the simd unary method f against the expected behavior generated by want
func testFloat32x4Unary(t *testing.T, f func(_ archsimd.Float32x4) archsimd.Float32x4, want func(_ []float32) []float32) {
	n := 4
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x4Slice(x)
		g := make([]float32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x2Unary tests the simd unary method f against the expected behavior generated by want
func testFloat64x2Unary(t *testing.T, f func(_ archsimd.Float64x2) archsimd.Float64x2, want func(_ []float64) []float64) {
	n := 2
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x2Slice(x)
		g := make([]float64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32Unary tests the simd unary method f against the expected behavior generated by want
func testInt8x32Unary(t *testing.T, f func(_ archsimd.Int8x32) archsimd.Int8x32, want func(_ []int8) []int8) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]int8, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16Unary tests the simd unary method f against the expected behavior generated by want
func testInt16x16Unary(t *testing.T, f func(_ archsimd.Int16x16) archsimd.Int16x16, want func(_ []int16) []int16) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]int16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8Unary tests the simd unary method f against the expected behavior generated by want
func testInt32x8Unary(t *testing.T, f func(_ archsimd.Int32x8) archsimd.Int32x8, want func(_ []int32) []int32) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4Unary tests the simd unary method f against the expected behavior generated by want
func testInt64x4Unary(t *testing.T, f func(_ archsimd.Int64x4) archsimd.Int64x4, want func(_ []int64) []int64) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]int64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32Unary tests the simd unary method f against the expected behavior generated by want
func testUint8x32Unary(t *testing.T, f func(_ archsimd.Uint8x32) archsimd.Uint8x32, want func(_ []uint8) []uint8) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]uint8, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16Unary tests the simd unary method f against the expected behavior generated by want
func testUint16x16Unary(t *testing.T, f func(_ archsimd.Uint16x16) archsimd.Uint16x16, want func(_ []uint16) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8Unary tests the simd unary method f against the expected behavior generated by want
func testUint32x8Unary(t *testing.T, f func(_ archsimd.Uint32x8) archsimd.Uint32x8, want func(_ []uint32) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4Unary tests the simd unary method f against the expected behavior generated by want
func testUint64x4Unary(t *testing.T, f func(_ archsimd.Uint64x4) archsimd.Uint64x4, want func(_ []uint64) []uint64) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]uint64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x8Unary tests the simd unary method f against the expected behavior generated by want
func testFloat32x8Unary(t *testing.T, f func(_ archsimd.Float32x8) archsimd.Float32x8, want func(_ []float32) []float32) {
	n := 8
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x8Slice(x)
		g := make([]float32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x4Unary tests the simd unary method f against the expected behavior generated by want
func testFloat64x4Unary(t *testing.T, f func(_ archsimd.Float64x4) archsimd.Float64x4, want func(_ []float64) []float64) {
	n := 4
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x4Slice(x)
		g := make([]float64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x64Unary tests the simd unary method f against the expected behavior generated by want
func testInt8x64Unary(t *testing.T, f func(_ archsimd.Int8x64) archsimd.Int8x64, want func(_ []int8) []int8) {
	n := 64
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x64Slice(x)
		g := make([]int8, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32Unary tests the simd unary method f against the expected behavior generated by want
func testInt16x32Unary(t *testing.T, f func(_ archsimd.Int16x32) archsimd.Int16x32, want func(_ []int16) []int16) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]int16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16Unary tests the simd unary method f against the expected behavior generated by want
func testInt32x16Unary(t *testing.T, f func(_ archsimd.Int32x16) archsimd.Int32x16, want func(_ []int32) []int32) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8Unary tests the simd unary method f against the expected behavior generated by want
func testInt64x8Unary(t *testing.T, f func(_ archsimd.Int64x8) archsimd.Int64x8, want func(_ []int64) []int64) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]int64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x64Unary tests the simd unary method f against the expected behavior generated by want
func testUint8x64Unary(t *testing.T, f func(_ archsimd.Uint8x64) archsimd.Uint8x64, want func(_ []uint8) []uint8) {
	n := 64
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x64Slice(x)
		g := make([]uint8, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32Unary tests the simd unary method f against the expected behavior generated by want
func testUint16x32Unary(t *testing.T, f func(_ archsimd.Uint16x32) archsimd.Uint16x32, want func(_ []uint16) []uint16) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16Unary tests the simd unary method f against the expected behavior generated by want
func testUint32x16Unary(t *testing.T, f func(_ archsimd.Uint32x16) archsimd.Uint32x16, want func(_ []uint32) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8Unary tests the simd unary method f against the expected behavior generated by want
func testUint64x8Unary(t *testing.T, f func(_ archsimd.Uint64x8) archsimd.Uint64x8, want func(_ []uint64) []uint64) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]uint64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x16Unary tests the simd unary method f against the expected behavior generated by want
func testFloat32x16Unary(t *testing.T, f func(_ archsimd.Float32x16) archsimd.Float32x16, want func(_ []float32) []float32) {
	n := 16
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x16Slice(x)
		g := make([]float32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x8Unary tests the simd unary method f against the expected behavior generated by want
func testFloat64x8Unary(t *testing.T, f func(_ archsimd.Float64x8) archsimd.Float64x8, want func(_ []float64) []float64) {
	n := 8
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x8Slice(x)
		g := make([]float64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt8x16ConvertToInt32(t *testing.T, f func(x archsimd.Int8x16) archsimd.Int32x16, want func(x []int8) []int32) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt16x8ConvertToInt32(t *testing.T, f func(x archsimd.Int16x8) archsimd.Int32x8, want func(x []int16) []int32) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt32x4ConvertToInt32(t *testing.T, f func(x archsimd.Int32x4) archsimd.Int32x4, want func(x []int32) []int32) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint8x16ConvertToInt32(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Int32x16, want func(x []uint8) []int32) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint16x8ConvertToInt32(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Int32x8, want func(x []uint16) []int32) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint32x4ConvertToInt32(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Int32x4, want func(x []uint32) []int32) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x4ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testFloat32x4ConvertToInt32(t *testing.T, f func(x archsimd.Float32x4) archsimd.Int32x4, want func(x []float32) []int32) {
	n := 4
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x4Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt16x16ConvertToInt32(t *testing.T, f func(x archsimd.Int16x16) archsimd.Int32x16, want func(x []int16) []int32) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt32x8ConvertToInt32(t *testing.T, f func(x archsimd.Int32x8) archsimd.Int32x8, want func(x []int32) []int32) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt64x4ConvertToInt32(t *testing.T, f func(x archsimd.Int64x4) archsimd.Int32x4, want func(x []int64) []int32) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint16x16ConvertToInt32(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Int32x16, want func(x []uint16) []int32) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint32x8ConvertToInt32(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Int32x8, want func(x []uint32) []int32) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint64x4ConvertToInt32(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Int32x4, want func(x []uint64) []int32) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x8ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testFloat32x8ConvertToInt32(t *testing.T, f func(x archsimd.Float32x8) archsimd.Int32x8, want func(x []float32) []int32) {
	n := 8
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x8Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x4ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testFloat64x4ConvertToInt32(t *testing.T, f func(x archsimd.Float64x4) archsimd.Int32x4, want func(x []float64) []int32) {
	n := 4
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x4Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt32x16ConvertToInt32(t *testing.T, f func(x archsimd.Int32x16) archsimd.Int32x16, want func(x []int32) []int32) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt64x8ConvertToInt32(t *testing.T, f func(x archsimd.Int64x8) archsimd.Int32x8, want func(x []int64) []int32) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint32x16ConvertToInt32(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Int32x16, want func(x []uint32) []int32) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint64x8ConvertToInt32(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Int32x8, want func(x []uint64) []int32) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x16ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testFloat32x16ConvertToInt32(t *testing.T, f func(x archsimd.Float32x16) archsimd.Int32x16, want func(x []float32) []int32) {
	n := 16
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x16Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x8ConvertToInt32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testFloat64x8ConvertToInt32(t *testing.T, f func(x archsimd.Float64x8) archsimd.Int32x8, want func(x []float64) []int32) {
	n := 8
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x8Slice(x)
		g := make([]int32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt8x16ConvertToUint32(t *testing.T, f func(x archsimd.Int8x16) archsimd.Uint32x16, want func(x []int8) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt16x8ConvertToUint32(t *testing.T, f func(x archsimd.Int16x8) archsimd.Uint32x8, want func(x []int16) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x4ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt32x4ConvertToUint32(t *testing.T, f func(x archsimd.Int32x4) archsimd.Uint32x4, want func(x []int32) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x4Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint8x16ConvertToUint32(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Uint32x16, want func(x []uint8) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint16x8ConvertToUint32(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Uint32x8, want func(x []uint16) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x4ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint32x4ConvertToUint32(t *testing.T, f func(x archsimd.Uint32x4) archsimd.Uint32x4, want func(x []uint32) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x4Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x4ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testFloat32x4ConvertToUint32(t *testing.T, f func(x archsimd.Float32x4) archsimd.Uint32x4, want func(x []float32) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x4Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt16x16ConvertToUint32(t *testing.T, f func(x archsimd.Int16x16) archsimd.Uint32x16, want func(x []int16) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt32x8ConvertToUint32(t *testing.T, f func(x archsimd.Int32x8) archsimd.Uint32x8, want func(x []int32) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x4ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt64x4ConvertToUint32(t *testing.T, f func(x archsimd.Int64x4) archsimd.Uint32x4, want func(x []int64) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x4Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint16x16ConvertToUint32(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Uint32x16, want func(x []uint16) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint32x8ConvertToUint32(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Uint32x8, want func(x []uint32) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x4ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint64x4ConvertToUint32(t *testing.T, f func(x archsimd.Uint64x4) archsimd.Uint32x4, want func(x []uint64) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x4Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x8ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testFloat32x8ConvertToUint32(t *testing.T, f func(x archsimd.Float32x8) archsimd.Uint32x8, want func(x []float32) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x8Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x4ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testFloat64x4ConvertToUint32(t *testing.T, f func(x archsimd.Float64x4) archsimd.Uint32x4, want func(x []float64) []uint32) {
	n := 4
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x4Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt32x16ConvertToUint32(t *testing.T, f func(x archsimd.Int32x16) archsimd.Uint32x16, want func(x []int32) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt64x8ConvertToUint32(t *testing.T, f func(x archsimd.Int64x8) archsimd.Uint32x8, want func(x []int64) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint32x16ConvertToUint32(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Uint32x16, want func(x []uint32) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint64x8ConvertToUint32(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Uint32x8, want func(x []uint64) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x16ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testFloat32x16ConvertToUint32(t *testing.T, f func(x archsimd.Float32x16) archsimd.Uint32x16, want func(x []float32) []uint32) {
	n := 16
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x16Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x8ConvertToUint32 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testFloat64x8ConvertToUint32(t *testing.T, f func(x archsimd.Float64x8) archsimd.Uint32x8, want func(x []float64) []uint32) {
	n := 8
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x8Slice(x)
		g := make([]uint32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x16ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt8x16ConvertToUint16(t *testing.T, f func(x archsimd.Int8x16) archsimd.Uint16x16, want func(x []int8) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x16Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x8ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt16x8ConvertToUint16(t *testing.T, f func(x archsimd.Int16x8) archsimd.Uint16x8, want func(x []int16) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x8Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x16ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint8x16ConvertToUint16(t *testing.T, f func(x archsimd.Uint8x16) archsimd.Uint16x16, want func(x []uint8) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x16Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x8ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint16x8ConvertToUint16(t *testing.T, f func(x archsimd.Uint16x8) archsimd.Uint16x8, want func(x []uint16) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x8Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt8x32ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt8x32ConvertToUint16(t *testing.T, f func(x archsimd.Int8x32) archsimd.Uint16x32, want func(x []int8) []uint16) {
	n := 32
	t.Helper()
	forSlice(t, int8s, n, func(x []int8) bool {
		t.Helper()
		a := archsimd.LoadInt8x32Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x16ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt16x16ConvertToUint16(t *testing.T, f func(x archsimd.Int16x16) archsimd.Uint16x16, want func(x []int16) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x16Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x8ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt32x8ConvertToUint16(t *testing.T, f func(x archsimd.Int32x8) archsimd.Uint16x8, want func(x []int32) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x8Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint8x32ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint8x32ConvertToUint16(t *testing.T, f func(x archsimd.Uint8x32) archsimd.Uint16x32, want func(x []uint8) []uint16) {
	n := 32
	t.Helper()
	forSlice(t, uint8s, n, func(x []uint8) bool {
		t.Helper()
		a := archsimd.LoadUint8x32Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x16ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint16x16ConvertToUint16(t *testing.T, f func(x archsimd.Uint16x16) archsimd.Uint16x16, want func(x []uint16) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x16Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x8ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint32x8ConvertToUint16(t *testing.T, f func(x archsimd.Uint32x8) archsimd.Uint16x8, want func(x []uint32) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x8Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x8ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testFloat32x8ConvertToUint16(t *testing.T, f func(x archsimd.Float32x8) archsimd.Uint16x8, want func(x []float32) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x8Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt16x32ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt16x32ConvertToUint16(t *testing.T, f func(x archsimd.Int16x32) archsimd.Uint16x32, want func(x []int16) []uint16) {
	n := 32
	t.Helper()
	forSlice(t, int16s, n, func(x []int16) bool {
		t.Helper()
		a := archsimd.LoadInt16x32Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt32x16ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt32x16ConvertToUint16(t *testing.T, f func(x archsimd.Int32x16) archsimd.Uint16x16, want func(x []int32) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, int32s, n, func(x []int32) bool {
		t.Helper()
		a := archsimd.LoadInt32x16Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testInt64x8ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testInt64x8ConvertToUint16(t *testing.T, f func(x archsimd.Int64x8) archsimd.Uint16x8, want func(x []int64) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, int64s, n, func(x []int64) bool {
		t.Helper()
		a := archsimd.LoadInt64x8Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint16x32ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint16x32ConvertToUint16(t *testing.T, f func(x archsimd.Uint16x32) archsimd.Uint16x32, want func(x []uint16) []uint16) {
	n := 32
	t.Helper()
	forSlice(t, uint16s, n, func(x []uint16) bool {
		t.Helper()
		a := archsimd.LoadUint16x32Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint32x16ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint32x16ConvertToUint16(t *testing.T, f func(x archsimd.Uint32x16) archsimd.Uint16x16, want func(x []uint32) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, uint32s, n, func(x []uint32) bool {
		t.Helper()
		a := archsimd.LoadUint32x16Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testUint64x8ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testUint64x8ConvertToUint16(t *testing.T, f func(x archsimd.Uint64x8) archsimd.Uint16x8, want func(x []uint64) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, uint64s, n, func(x []uint64) bool {
		t.Helper()
		a := archsimd.LoadUint64x8Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x16ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testFloat32x16ConvertToUint16(t *testing.T, f func(x archsimd.Float32x16) archsimd.Uint16x16, want func(x []float32) []uint16) {
	n := 16
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x16Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x8ConvertToUint16 tests the simd conversion method f against the expected behavior generated by want
// This is for count-preserving conversions, so if there is a change in size, then there is a change in vector width.
func testFloat64x8ConvertToUint16(t *testing.T, f func(x archsimd.Float64x8) archsimd.Uint16x8, want func(x []float64) []uint16) {
	n := 8
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x8Slice(x)
		g := make([]uint16, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, 0.0, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x4UnaryFlaky tests the simd unary method f against the expected behavior generated by want,
// but using a flakiness parameter because we haven't exactly figured out how simd floating point works
func testFloat32x4UnaryFlaky(t *testing.T, f func(x archsimd.Float32x4) archsimd.Float32x4, want func(x []float32) []float32, flakiness float64) {
	n := 4
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x4Slice(x)
		g := make([]float32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, flakiness, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x2UnaryFlaky tests the simd unary method f against the expected behavior generated by want,
// but using a flakiness parameter because we haven't exactly figured out how simd floating point works
func testFloat64x2UnaryFlaky(t *testing.T, f func(x archsimd.Float64x2) archsimd.Float64x2, want func(x []float64) []float64, flakiness float64) {
	n := 2
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x2Slice(x)
		g := make([]float64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, flakiness, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x8UnaryFlaky tests the simd unary method f against the expected behavior generated by want,
// but using a flakiness parameter because we haven't exactly figured out how simd floating point works
func testFloat32x8UnaryFlaky(t *testing.T, f func(x archsimd.Float32x8) archsimd.Float32x8, want func(x []float32) []float32, flakiness float64) {
	n := 8
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x8Slice(x)
		g := make([]float32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, flakiness, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x4UnaryFlaky tests the simd unary method f against the expected behavior generated by want,
// but using a flakiness parameter because we haven't exactly figured out how simd floating point works
func testFloat64x4UnaryFlaky(t *testing.T, f func(x archsimd.Float64x4) archsimd.Float64x4, want func(x []float64) []float64, flakiness float64) {
	n := 4
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x4Slice(x)
		g := make([]float64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, flakiness, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat32x16UnaryFlaky tests the simd unary method f against the expected behavior generated by want,
// but using a flakiness parameter because we haven't exactly figured out how simd floating point works
func testFloat32x16UnaryFlaky(t *testing.T, f func(x archsimd.Float32x16) archsimd.Float32x16, want func(x []float32) []float32, flakiness float64) {
	n := 16
	t.Helper()
	forSlice(t, float32s, n, func(x []float32) bool {
		t.Helper()
		a := archsimd.LoadFloat32x16Slice(x)
		g := make([]float32, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, flakiness, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}

// testFloat64x8UnaryFlaky tests the simd unary method f against the expected behavior generated by want,
// but using a flakiness parameter because we haven't exactly figured out how simd floating point works
func testFloat64x8UnaryFlaky(t *testing.T, f func(x archsimd.Float64x8) archsimd.Float64x8, want func(x []float64) []float64, flakiness float64) {
	n := 8
	t.Helper()
	forSlice(t, float64s, n, func(x []float64) bool {
		t.Helper()
		a := archsimd.LoadFloat64x8Slice(x)
		g := make([]float64, n)
		f(a).StoreSlice(g)
		w := want(x)
		return checkSlicesLogInput(t, g, w, flakiness, func() { t.Helper(); t.Logf("x=%v", x) })
	})
}
