/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.MattermostAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class MattermostAnnouncerValidator {
    private static final String DEFAULT_MATTERMOST_TPL = "src/jreleaser/templates/mattermost.tpl";

    private MattermostAnnouncerValidator() {
    }

    public static void validateMattermost(JReleaserContext context, MattermostAnnouncer announcer, Errors errors) {
        context.getLogger().debug("announce.mattermost");
        Validator.resolveActivatable(context, (Activatable)announcer, "announce.mattermost", "NEVER");
        if (!announcer.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        announcer.setWebhook(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.mattermost.webhook", "MATTERMOST_WEBHOOK"}), "announce.mattermost.webhook", announcer.getWebhook(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)announcer.getMessage()) && StringUtils.isBlank((String)announcer.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_MATTERMOST_TPL), new LinkOption[0])) {
                announcer.setMessageTemplate(DEFAULT_MATTERMOST_TPL);
            } else {
                announcer.setMessage(RB.$((String)"default.release.message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)announcer.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(announcer.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"mattermost.messageTemplate", announcer.getMessageTemplate()}));
        }
        Validator.validateTimeout(announcer);
    }
}

