/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.spi.catalog.sbom;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.catalog.sbom.SbomCataloger;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;

public abstract class SbomCatalogerProcessorHelper {
    private static final Set<String> SUPPORTED_EXTENSIONS = CollectionUtils.setOf((Object[])new String[]{FileType.ZIP.extension(), FileType.JAR.extension(), FileType.TAR.extension(), FileType.TAR_BZ2.extension(), FileType.TAR_GZ.extension(), FileType.TAR_XZ.extension(), FileType.TBZ2.extension(), FileType.TGZ.extension(), FileType.TXZ.extension()});

    private SbomCatalogerProcessorHelper() {
    }

    public static Set<Artifact> resolveArtifacts(JReleaserContext context) {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        List<SbomCataloger<?>> catalogers = context.getModel().getCatalog().getSbom().findAllActiveSbomCatalogers();
        for (SbomCataloger<?> cataloger : catalogers) {
            artifacts.addAll(SbomCatalogerProcessorHelper.resolveArtifacts(context, cataloger));
        }
        return artifacts;
    }

    public static Set<Artifact> resolveArtifacts(JReleaserContext context, SbomCataloger<?> cataloger) {
        Set<Artifact> candidates = SbomCatalogerProcessorHelper.collectArtifacts(context, cataloger);
        return cataloger.resolveArtifacts(context, candidates);
    }

    public static Set<Artifact> collectArtifacts(JReleaserContext context) {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        List<SbomCataloger<?>> catalogers = context.getModel().getCatalog().getSbom().findAllActiveSbomCatalogers();
        for (SbomCataloger<?> cataloger : catalogers) {
            artifacts.addAll(SbomCatalogerProcessorHelper.collectArtifacts(context, cataloger));
        }
        return artifacts;
    }

    public static Set<Artifact> collectArtifacts(JReleaserContext context, SbomCataloger<?> cataloger) {
        LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
        if (cataloger.isFiles()) {
            for (Artifact artifact : Artifacts.resolveFiles(context)) {
                if (!SbomCatalogerProcessorHelper.isArtifactSupported(artifact) || cataloger.isSkipped(artifact) || !artifact.isActiveAndSelected() || artifact.isOptional(context) && !artifact.resolvedPathExists()) continue;
                artifacts.add(artifact);
            }
        }
        for (Distribution distribution : context.getModel().getActiveDistributions()) {
            if (cataloger.isSkipped(distribution)) continue;
            for (Artifact artifact : distribution.getArtifacts()) {
                if (!artifact.isActiveAndSelected() || cataloger.isSkipped(artifact)) continue;
                artifact.getEffectivePath(context, distribution);
                if (!SbomCatalogerProcessorHelper.isArtifactSupported(artifact) || artifact.isOptional(context) && !artifact.resolvedPathExists()) continue;
                artifacts.add(artifact);
            }
        }
        return artifacts;
    }

    private static boolean isArtifactSupported(Artifact artifact) {
        String filename = artifact.getEffectivePath().getFileName().toString();
        for (String extension : SUPPORTED_EXTENSIONS) {
            if (!filename.endsWith(extension)) continue;
            return true;
        }
        return false;
    }
}

