/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.hooks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.common.Matrix;
import org.jreleaser.model.api.hooks.Hook;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.hooks.AbstractHook;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;

public final class JbangHook
extends AbstractHook<JbangHook> {
    private static final long serialVersionUID = 1424105110415449550L;
    private final List<String> args = new ArrayList<String>();
    private final List<String> jbangArgs = new ArrayList<String>();
    private final List<String> trusts = new ArrayList<String>();
    private String version;
    private String script;
    @JsonIgnore
    private final org.jreleaser.model.api.hooks.JbangHook immutable = new org.jreleaser.model.api.hooks.JbangHook(){
        private static final long serialVersionUID = 3117507984015002700L;

        public String getVersion() {
            return JbangHook.this.version;
        }

        public String getScript() {
            return JbangHook.this.script;
        }

        public List<String> getArgs() {
            return Collections.unmodifiableList(JbangHook.this.args);
        }

        public List<String> getJbangArgs() {
            return Collections.unmodifiableList(JbangHook.this.jbangArgs);
        }

        public List<String> getTrusts() {
            return Collections.unmodifiableList(JbangHook.this.trusts);
        }

        public Map<String, String> getEnvironment() {
            return Collections.unmodifiableMap(JbangHook.this.getEnvironment());
        }

        public boolean isApplyDefaultMatrix() {
            return JbangHook.this.isApplyDefaultMatrix();
        }

        public Matrix getMatrix() {
            return JbangHook.this.matrix.asImmutable();
        }

        public Set<String> getPlatforms() {
            return Collections.unmodifiableSet(JbangHook.this.getPlatforms());
        }

        public Hook.Filter getFilter() {
            return JbangHook.this.getFilter().asImmutable();
        }

        public boolean isContinueOnError() {
            return JbangHook.this.isContinueOnError();
        }

        public boolean isVerbose() {
            return JbangHook.this.isVerbose();
        }

        public String getCondition() {
            return JbangHook.this.getCondition();
        }

        public Active getActive() {
            return JbangHook.this.getActive();
        }

        public boolean isEnabled() {
            return JbangHook.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(JbangHook.this.asMap(full));
        }
    };

    public org.jreleaser.model.api.hooks.JbangHook asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(JbangHook source) {
        super.merge(source);
        this.version = this.merge(this.version, source.version);
        this.script = this.merge(this.script, source.script);
        this.setArgs(this.merge(this.args, source.args));
        this.setJbangArgs(this.merge(this.jbangArgs, source.jbangArgs));
        this.setTrusts(this.merge(this.trusts, source.trusts));
    }

    public String getResolvedScript(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        context.getModel().getRelease().getReleaser().fillProps(props, context);
        return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)this.script, (TemplateContext)props);
    }

    public List<String> getResolvedArgs(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        context.getModel().getRelease().getReleaser().fillProps(props, context);
        return this.args.stream().map(s -> Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)s, (TemplateContext)props)).collect(Collectors.toList());
    }

    public List<String> getResolvedJbangArgs(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        context.getModel().getRelease().getReleaser().fillProps(props, context);
        return this.jbangArgs.stream().map(s -> Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)s, (TemplateContext)props)).collect(Collectors.toList());
    }

    public List<String> getResolvedTrusts(JReleaserContext context) {
        TemplateContext props = context.fullProps();
        context.getModel().getRelease().getReleaser().fillProps(props, context);
        return this.trusts.stream().map(s -> Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)s, (TemplateContext)props)).collect(Collectors.toList());
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args.clear();
        this.args.addAll(args);
    }

    public List<String> getJbangArgs() {
        return this.jbangArgs;
    }

    public void setJbangArgs(List<String> jbangArgs) {
        this.jbangArgs.clear();
        this.jbangArgs.addAll(jbangArgs);
    }

    public List<String> getTrusts() {
        return this.trusts;
    }

    public void setTrusts(List<String> trusts) {
        this.trusts.clear();
        this.trusts.addAll(trusts);
    }

    @Override
    public void asMap(boolean full, Map<String, Object> map) {
        map.put("version", this.version);
        map.put("script", this.script);
        map.put("args", this.args);
        map.put("jbangArgs", this.jbangArgs);
        map.put("trusts", this.trusts);
    }
}

