/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.packagers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.api.packagers.JibConfiguration;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.packagers.AbstractJibConfiguration;
import org.jreleaser.model.internal.packagers.JibConfiguration;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class JibSpec
extends AbstractJibConfiguration<JibSpec>
implements Domain {
    private static final long serialVersionUID = -7696534492476787337L;
    private final Map<String, Object> matchers = new LinkedHashMap<String, Object>();
    private Artifact artifact;
    private String name;
    @JsonIgnore
    private final org.jreleaser.model.api.packagers.JibSpec immutable = new org.jreleaser.model.api.packagers.JibSpec(){
        private static final long serialVersionUID = 3806780814992744269L;
        private Set<? extends JibConfiguration.Registry> registries;

        public org.jreleaser.model.api.common.Artifact getArtifact() {
            return JibSpec.this.artifact.asImmutable();
        }

        public String getName() {
            return JibSpec.this.name;
        }

        public Map<String, Object> getMatchers() {
            return Collections.unmodifiableMap(JibSpec.this.matchers);
        }

        public String getTemplateDirectory() {
            return JibSpec.this.getTemplateDirectory();
        }

        public List<String> getSkipTemplates() {
            return Collections.unmodifiableList(JibSpec.this.getSkipTemplates());
        }

        public String getBaseImage() {
            return JibSpec.this.getBaseImage();
        }

        public String getCreationTime() {
            return JibSpec.this.getCreationTime();
        }

        public JibConfiguration.Format getFormat() {
            return JibSpec.this.getFormat();
        }

        public Map<String, String> getEnvironment() {
            return Collections.unmodifiableMap(JibSpec.this.getEnvironment());
        }

        public Set<String> getVolumes() {
            return Collections.unmodifiableSet(JibSpec.this.getVolumes());
        }

        public Set<String> getExposedPorts() {
            return Collections.unmodifiableSet(JibSpec.this.getExposedPorts());
        }

        public String getUser() {
            return JibSpec.this.getUser();
        }

        public String getWorkingDirectory() {
            return JibSpec.this.getWorkingDirectory();
        }

        public Map<String, String> getLabels() {
            return Collections.unmodifiableMap(JibSpec.this.getLabels());
        }

        public Set<String> getImageNames() {
            return Collections.unmodifiableSet(JibSpec.this.getImageNames());
        }

        public Set<? extends JibConfiguration.Registry> getRegistries() {
            if (null == this.registries) {
                this.registries = JibSpec.this.getRegistries().stream().map(JibConfiguration.Registry::asImmutable).collect(Collectors.toSet());
            }
            return this.registries;
        }

        public Active getActive() {
            return JibSpec.this.getActive();
        }

        public boolean isEnabled() {
            return JibSpec.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(JibSpec.this.asMap(full));
        }

        public String getPrefix() {
            return JibSpec.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(JibSpec.this.getExtraProperties());
        }
    };

    public org.jreleaser.model.api.packagers.JibSpec asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(JibSpec source) {
        super.merge(source);
        this.name = this.merge(this.name, source.name);
        this.artifact = source.artifact;
        this.setMatchers(this.merge(this.matchers, source.matchers));
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
        this.artifact.select();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getMatchers() {
        return this.matchers;
    }

    public void setMatchers(Map<String, Object> matchers) {
        this.matchers.putAll(matchers);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        Map<String, Object> props = super.asMap(full);
        if (!props.isEmpty()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(this.name, props);
            return map;
        }
        return props;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("matchers", this.matchers);
        if (null != this.artifact) {
            props.put("artifact", this.artifact.asMap(full));
        }
    }

    public boolean matches(Artifact artifact) {
        boolean matched = true;
        for (Map.Entry<String, Object> e : this.matchers.entrySet()) {
            String key = e.getKey();
            if ("platform".equals(key)) {
                matched &= StringUtils.isNotBlank((String)artifact.getPlatform()) && PlatformUtils.isCompatible((String)String.valueOf(e.getValue()), (String)artifact.getPlatform());
                continue;
            }
            if (!artifact.getExtraProperties().containsKey(key)) continue;
            matched &= e.getValue().equals(artifact.getExtraProperties().get(key));
        }
        return matched;
    }
}

