/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.upload;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.Map;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.Active;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Ftp;
import org.jreleaser.model.internal.common.FtpDelegate;
import org.jreleaser.model.internal.upload.AbstractUploader;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;

public final class FtpUploader
extends AbstractUploader<org.jreleaser.model.api.upload.FtpUploader, FtpUploader>
implements Ftp {
    private static final long serialVersionUID = -7427075974576853678L;
    private final FtpDelegate delegate = new FtpDelegate();
    private String path;
    private String downloadUrl;
    @JsonIgnore
    private final org.jreleaser.model.api.upload.FtpUploader immutable = new org.jreleaser.model.api.upload.FtpUploader(){
        private static final long serialVersionUID = -1377876046305087409L;

        public String getPath() {
            return FtpUploader.this.path;
        }

        public String getDownloadUrl() {
            return FtpUploader.this.downloadUrl;
        }

        public String getUsername() {
            return FtpUploader.this.getUsername();
        }

        public String getPassword() {
            return FtpUploader.this.getPassword();
        }

        public String getHost() {
            return FtpUploader.this.getHost();
        }

        public Integer getPort() {
            return FtpUploader.this.getPort();
        }

        public String getType() {
            return FtpUploader.this.getType();
        }

        public String getName() {
            return FtpUploader.this.getName();
        }

        public boolean isSnapshotSupported() {
            return FtpUploader.this.isSnapshotSupported();
        }

        public boolean isArtifacts() {
            return FtpUploader.this.isArtifacts();
        }

        public boolean isFiles() {
            return FtpUploader.this.isFiles();
        }

        public boolean isSignatures() {
            return FtpUploader.this.isSignatures();
        }

        public boolean isChecksums() {
            return FtpUploader.this.isChecksums();
        }

        public boolean isCatalogs() {
            return FtpUploader.this.isCatalogs();
        }

        public Active getActive() {
            return FtpUploader.this.getActive();
        }

        public boolean isEnabled() {
            return FtpUploader.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(FtpUploader.this.asMap(full));
        }

        public String getPrefix() {
            return FtpUploader.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(FtpUploader.this.getExtraProperties());
        }

        public Integer getConnectTimeout() {
            return FtpUploader.this.getConnectTimeout();
        }

        public Integer getReadTimeout() {
            return FtpUploader.this.getReadTimeout();
        }
    };

    public FtpUploader() {
        super("ftp");
    }

    @Override
    public org.jreleaser.model.api.upload.FtpUploader asImmutable() {
        return this.immutable;
    }

    @Override
    public void merge(FtpUploader source) {
        super.merge(source);
        this.delegate.merge(source.delegate);
        this.path = this.merge(this.path, source.path);
        this.downloadUrl = this.merge(this.downloadUrl, source.downloadUrl);
    }

    @Override
    public String getUsername() {
        return this.delegate.getUsername();
    }

    @Override
    public void setUsername(String username) {
        this.delegate.setUsername(username);
    }

    @Override
    public String getPassword() {
        return this.delegate.getPassword();
    }

    @Override
    public void setPassword(String password) {
        this.delegate.setPassword(password);
    }

    @Override
    public String getHost() {
        return this.delegate.getHost();
    }

    @Override
    public void setHost(String host) {
        this.delegate.setHost(host);
    }

    @Override
    public Integer getPort() {
        return this.delegate.getPort();
    }

    @Override
    public void setPort(Integer port) {
        this.delegate.setPort(port);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        this.delegate.asMap(props);
        props.put("path", this.path);
        props.put("downloadUrl", this.downloadUrl);
    }

    public String getResolvedPath(JReleaserContext context, Artifact artifact) {
        TemplateContext p = this.artifactProps(context.fullProps(), artifact);
        p.setAll(this.resolvedExtraProperties());
        return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)this.path, (TemplateContext)p);
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, Artifact artifact) {
        return this.getResolvedDownloadUrl(context, context.fullProps(), artifact);
    }

    @Override
    public String getResolvedDownloadUrl(JReleaserContext context, TemplateContext props, Artifact artifact) {
        TemplateContext p = new TemplateContext(this.artifactProps(props, artifact));
        p.setAll(this.resolvedExtraProperties());
        return Templates.resolveTemplate((JReleaserLogger)context.getLogger(), (String)this.downloadUrl, (TemplateContext)p);
    }
}

