/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.deploy.maven;

import java.util.Map;
import java.util.Properties;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.api.deploy.maven.MavenCentralMavenDeployer;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.deploy.maven.MavenCentralMavenDeployer;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.deploy.maven.MavenDeployersValidator;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class MavenCentralMavenDeployerValidator {
    private MavenCentralMavenDeployerValidator() {
    }

    public static void validateMavenCentralMavenDeployer(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, MavenCentralMavenDeployer> mavenCentral = context.getModel().getDeploy().getMaven().getMavenCentral();
        if (!mavenCentral.isEmpty()) {
            context.getLogger().debug("deploy.maven.mavenCentral");
        }
        for (Map.Entry<String, MavenCentralMavenDeployer> e : mavenCentral.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateDeploy() && !mode.validateConfig()) continue;
            Errors incoming = new Errors();
            MavenCentralMavenDeployerValidator.validateMavenCentralMavenDeployer(context, e.getValue(), incoming);
            Validator.mergeErrors(context, errors, incoming, e.getValue());
        }
    }

    private static void validateMavenCentralMavenDeployer(JReleaserContext context, MavenCentralMavenDeployer mavenDeployer, Errors errors) {
        if (!mavenDeployer.isApplyMavenCentralRulesSet()) {
            mavenDeployer.setApplyMavenCentralRules(true);
        }
        if (StringUtils.isBlank((String)mavenDeployer.getVerifyUrl()) && mavenDeployer.isApplyMavenCentralRules()) {
            mavenDeployer.setVerifyUrl("https://repo1.maven.org/maven2/{{path}}/{{filename}}");
        }
        MavenDeployersValidator.validateMavenDeployer(context, mavenDeployer, errors);
        if (!mavenDeployer.isEnabled()) {
            return;
        }
        Properties vars = context.getModel().getEnvironment().getVars();
        mavenDeployer.setStage(Env.resolve(mavenDeployer.keysFor("STAGE"), (Properties)vars));
        mavenDeployer.setDeploymentId(Env.resolve(mavenDeployer.keysFor("deployment.id"), (Properties)vars));
        if (null == mavenDeployer.getStage()) {
            mavenDeployer.setStage(MavenCentralMavenDeployer.Stage.FULL);
        }
        if (mavenDeployer.getRetryDelay() <= 0) {
            mavenDeployer.setRetryDelay(20);
        }
        if (mavenDeployer.getMaxRetries() <= 0) {
            mavenDeployer.setMaxRetries(100);
        }
        if (mavenDeployer.getStage() == MavenCentralMavenDeployer.Stage.PUBLISH) {
            mavenDeployer.setDeploymentId(Validator.checkProperty(context, mavenDeployer.keysFor("deployment.id"), "deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".deploymentId", mavenDeployer.getDeploymentId(), errors));
        }
        Errors tmp = new Errors();
        mavenDeployer.setNamespace(Validator.checkProperty(context, mavenDeployer.keysFor("namespace"), "deploy.maven." + mavenDeployer.getType() + "." + mavenDeployer.getName() + ".namespace", mavenDeployer.getNamespace(), tmp));
        if (StringUtils.isBlank((String)mavenDeployer.getNamespace())) {
            mavenDeployer.setNamespace(context.getModel().getProject().getLanguages().getJava().getGroupId());
        }
        if (StringUtils.isBlank((String)mavenDeployer.getNamespace())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"project.java.groupId"}));
            errors.addAll(tmp);
        }
    }
}

