/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.signing;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Signing;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.deploy.maven.MavenDeployer;
import org.jreleaser.model.internal.environment.Environment;
import org.jreleaser.model.internal.signing.Signing;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.DefaultVersions;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class SigningValidator {
    private SigningValidator() {
    }

    public static void validateSigning(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        if (!mode.validateConfig() && !mode.validateDeploy()) {
            errors = new Errors();
        }
        context.getLogger().debug("signing");
        Signing signing = context.getModel().getSigning();
        boolean activeSet = signing.isActiveSet();
        Validator.resolveActivatable(context, (Activatable)signing, "signing", "");
        SigningValidator.validatePgp(context, mode, signing.getPgp(), errors);
        SigningValidator.validateCosign(context, mode, signing.getCosign(), errors);
        SigningValidator.validateMinisign(context, mode, signing.getMinisign(), errors);
        if (!activeSet) {
            boolean enabled;
            boolean bl = enabled = signing.getPgp().isEnabled() || signing.getCosign().isEnabled() || signing.getMinisign().isEnabled();
            if (enabled) {
                signing.setActive(Active.ALWAYS);
                signing.resolveEnabled(context.getModel().getProject());
            } else {
                signing.setActive(Active.NEVER);
            }
        }
        signing.resolveEnabled(context.getModel().getProject());
    }

    private static void validatePgp(JReleaserContext context, JReleaserContext.Mode mode, Signing.Pgp pgp, Errors errors) {
        context.getLogger().debug("signing.pgp");
        if (null == pgp.getActive()) {
            pgp.setActive(context.getModel().getSigning().getActive());
        }
        Validator.resolveActivatable(context, (Activatable)pgp, "signing.pgp", "NEVER");
        if (!pgp.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!pgp.isArmoredSet()) {
            pgp.setArmored(true);
        }
        String passphrase = SigningValidator.validatePassphrase(context, "GPG_PASSPHRASE", pgp.getPassphrase(), "signing.pgp.passphrase");
        pgp.setPassphrase(passphrase);
        if (pgp.resolveMode() == Signing.Mode.COMMAND) {
            pgp.getCommand().setExecutable(Validator.checkProperty(context, "GPG_EXECUTABLE", "signing.pgp.command.executable", pgp.getCommand().getExecutable(), "gpg" + (PlatformUtils.isWindows() ? ".exe" : "")));
            pgp.getCommand().setHomeDir(Validator.checkProperty(context, "GPG_HOMEDIR", "signing.pgp.command.homeDir", pgp.getCommand().getHomeDir(), ""));
            pgp.getCommand().setKeyName(Validator.checkProperty(context, "GPG_KEYNAME", "signing.pgp.command.keyName", pgp.getCommand().getKeyName(), ""));
            if (pgp.isVerify()) {
                pgp.getCommand().setPublicKeyring(Validator.checkProperty(context, "GPG_PUBLIC_KEYRING", "signing.pgp.command.publicKeyRing", pgp.getCommand().getPublicKeyring(), ""));
            }
        } else {
            if (pgp.isVerify()) {
                pgp.setPublicKey(Validator.checkProperty(context, "GPG_PUBLIC_KEY", "signing.pgp.publicKey", pgp.getPublicKey(), errors));
            }
            pgp.setSecretKey(Validator.checkProperty(context, "GPG_SECRET_KEY", "signing.pgp.secretKey", pgp.getSecretKey(), errors));
        }
    }

    private static void validateCosign(JReleaserContext context, JReleaserContext.Mode mode, Signing.Cosign cosign, Errors errors) {
        context.getLogger().debug("signing.cosign");
        Signing signing = context.getModel().getSigning();
        Validator.resolveActivatable(context, (Activatable)cosign, "signing.cosign", "NEVER");
        if (!cosign.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        String passphrase = SigningValidator.validatePassphrase(context, "COSIGN_PASSWORD", cosign.getPassphrase(), "signing.cosign.passphrase");
        cosign.setPassphrase(passphrase);
        if (StringUtils.isBlank((String)cosign.getPassphrase()) && StringUtils.isNotBlank((String)signing.getPgp().getPassphrase())) {
            cosign.setPassphrase(signing.getPgp().getPassphrase());
        }
        if (StringUtils.isBlank((String)cosign.getVersion())) {
            cosign.setVersion(DefaultVersions.getInstance().getCosignVersion());
        }
        cosign.setSecretKeyFile(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"COSIGN_PRIVATE_KEY", "COSIGN_SECRET_KEY"}), "signing.cosign.secretKeyFile", cosign.getSecretKeyFile(), ""));
        cosign.setPublicKeyFile(Validator.checkProperty(context, "COSIGN_PUBLIC_KEY", "signing.cosign.publicKeyFile", cosign.getPublicKeyFile(), ""));
    }

    private static void validateMinisign(JReleaserContext context, JReleaserContext.Mode mode, Signing.Minisign minisign, Errors errors) {
        context.getLogger().debug("signing.minisign");
        Signing signing = context.getModel().getSigning();
        Validator.resolveActivatable(context, (Activatable)minisign, "signing.minisign", "NEVER");
        if (!minisign.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        String passphrase = SigningValidator.validatePassphrase(context, "MINISIGN_PASSWORD", minisign.getPassphrase(), "signing.minisign.passphrase");
        minisign.setPassphrase(passphrase);
        if (StringUtils.isBlank((String)minisign.getPassphrase()) && StringUtils.isNotBlank((String)signing.getPgp().getPassphrase())) {
            minisign.setPassphrase(signing.getPgp().getPassphrase());
        }
        if (StringUtils.isBlank((String)minisign.getVersion())) {
            minisign.setVersion(DefaultVersions.getInstance().getMinisignVersion());
        }
        minisign.setSecretKeyFile(Validator.checkProperty(context, "MINISIGN_SECRET_KEY", "signing.minisign.secretKeyFile", minisign.getSecretKeyFile(), ""));
        minisign.setPublicKeyFile(Validator.checkProperty(context, "MINISIGN_PUBLIC_KEY", "signing.minisign.publicKeyFile", minisign.getPublicKeyFile(), ""));
        minisign.setPublicKeyFile(minisign.getResolvedPublicKeyFilePath(context).toString());
        Path secretKeyFile = signing.getMinisign().getResolvedSecretKeyFilePath(context);
        Path publicKeyFile = signing.getMinisign().getResolvedPublicKeyFilePath(context);
        if (!Files.exists(secretKeyFile, new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"minisign.secretKeyFile", secretKeyFile}));
        }
        if (!Files.exists(publicKeyFile, new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"minisign.publicKeyFile", publicKeyFile}));
        }
    }

    private static String validatePassphrase(JReleaserContext context, String passphraseKey, String value, String propertyKey) {
        String passphrase = Validator.checkProperty(context, passphraseKey, propertyKey, value, new Errors(), false);
        if (StringUtils.isBlank((String)passphrase)) {
            Environment environment = context.getModel().getEnvironment();
            String dsl = context.getConfigurer().toString();
            String configFilePath = environment.getPropertiesFile().toAbsolutePath().normalize().toString();
            String envKey = Env.envKey((String)passphraseKey);
            String sysKey = Env.sysKey((String)passphraseKey);
            context.getLogger().warn(RB.$((String)"signing.passphrase.blank", (Object[])new Object[]{dsl, sysKey, envKey, configFilePath, passphraseKey}));
            passphrase = "";
        }
        return passphrase;
    }

    public static void postValidateSigning(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        boolean checkSign;
        Signing signing = context.getModel().getSigning();
        if (!signing.isEnabled()) {
            return;
        }
        boolean bl = checkSign = mode == JReleaserContext.Mode.DEPLOY && context.getModel().getDeploy().getMaven().getActiveDeployers().stream().map(MavenDeployer::isSign).filter(b -> b).findAny().orElseGet(() -> false) != false;
        if (!checkSign) {
            return;
        }
        context.getLogger().debug("signing.pgp");
        Signing.Pgp pgp = signing.getPgp();
        if (pgp.isEnabled()) {
            if (pgp.resolveMode() == Signing.Mode.COMMAND) {
                if (pgp.isVerify()) {
                    pgp.getCommand().setPublicKeyring(Validator.checkProperty(context, "GPG_PUBLIC_KEYRING", "signing.pgp.command.publicKeyRing", pgp.getCommand().getPublicKeyring(), ""));
                }
            } else if ((pgp.resolveMode() == Signing.Mode.MEMORY || pgp.resolveMode() == Signing.Mode.FILE) && pgp.isVerify()) {
                pgp.setPublicKey(Validator.checkProperty(context, "GPG_PUBLIC_KEY", "signing.pgp.publicKey", pgp.getPublicKey(), errors));
            }
        }
    }
}

