/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.api.common;

import java.time.ZonedDateTime;
import java.util.Locale;
import org.jreleaser.model.api.common.Domain;
import org.jreleaser.util.StringUtils;

public interface ArchiveOptions
extends Domain {
    public ZonedDateTime getTimestamp();

    public TarMode getLongFileMode();

    public TarMode getBigNumberMode();

    public static enum TarMode {
        GNU,
        POSIX,
        ERROR,
        TRUNCATE;


        public String formatted() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public static TarMode of(String str) {
            if (StringUtils.isBlank((String)str)) {
                return null;
            }
            return TarMode.valueOf(str.toUpperCase(Locale.ENGLISH).trim());
        }
    }
}

