/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.nexus3;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.deploy.DeployException;
import org.jreleaser.model.spi.deploy.maven.Deployable;
import org.jreleaser.sdk.commons.AbstractMavenDeployer;
import org.jreleaser.sdk.nexus3.Nexus3;
import org.jreleaser.sdk.nexus3.Nexus3Exception;

public class Nexus3MavenDeployer
extends AbstractMavenDeployer<org.jreleaser.model.api.deploy.maven.Nexus3MavenDeployer, org.jreleaser.model.internal.deploy.maven.Nexus3MavenDeployer> {
    private org.jreleaser.model.internal.deploy.maven.Nexus3MavenDeployer deployer;

    public Nexus3MavenDeployer(JReleaserContext context) {
        super(context);
    }

    public org.jreleaser.model.internal.deploy.maven.Nexus3MavenDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(org.jreleaser.model.internal.deploy.maven.Nexus3MavenDeployer deployer) {
        this.deployer = deployer;
    }

    public String getType() {
        return "nexus3";
    }

    public void deploy(String name) throws DeployException {
        Set deployables = this.collectDeployables(false);
        String baseUrl = this.deployer.getResolvedUrl(this.context, this.context.fullProps());
        String username = this.deployer.getUsername();
        String password = this.deployer.getPassword();
        Nexus3 nexus = new Nexus3(this.context.asImmutable(), baseUrl, username, password, this.deployer.getConnectTimeout(), this.deployer.getReadTimeout(), this.context.isDryrun());
        LinkedHashMap<String, Map> groupedArtifacts = new LinkedHashMap<String, Map>();
        for (Deployable deployable : deployables) {
            groupedArtifacts.computeIfAbsent(deployable.getGroupId(), k1 -> new LinkedHashMap()).computeIfAbsent(deployable.getArtifactId(), k -> new LinkedHashSet()).add(deployable);
        }
        for (Map.Entry entry : groupedArtifacts.entrySet()) {
            String groupId = (String)entry.getKey();
            for (Map.Entry artifacts : ((Map)entry.getValue()).entrySet()) {
                for (Deployable deployable : (Set)artifacts.getValue()) {
                    this.context.getLogger().info(" - {}", new Object[]{deployable.getFullDeployPath()});
                }
                if (this.context.isDryrun()) continue;
                try {
                    nexus.deploy(groupId, (String)artifacts.getKey(), (Set)artifacts.getValue());
                }
                catch (Nexus3Exception e) {
                    this.context.getLogger().trace((Throwable)e);
                    throw new DeployException(RB.$((String)"ERROR_unexpected_deploy", (Object[])new Object[]{groupId + ":" + (String)artifacts.getKey(), e.getMessage()}), (Throwable)e);
                }
            }
        }
    }
}

