/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.linkedin;

import java.util.Map;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.sdk.linkedin.LinkedinException;
import org.jreleaser.sdk.linkedin.LinkedinSdk;
import org.jreleaser.sdk.linkedin.api.Message;
import org.jreleaser.util.StringUtils;

public class LinkedinAnnouncer
implements Announcer<org.jreleaser.model.api.announce.LinkedinAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.LinkedinAnnouncer linkedin;

    public LinkedinAnnouncer(JReleaserContext context) {
        this.context = context;
        this.linkedin = context.getModel().getAnnounce().getLinkedin();
    }

    public org.jreleaser.model.api.announce.LinkedinAnnouncer getAnnouncer() {
        return this.linkedin.asImmutable();
    }

    public String getName() {
        return "linkedin";
    }

    public boolean isEnabled() {
        return this.linkedin.isEnabled();
    }

    public void announce() throws AnnounceException {
        String owner = this.linkedin.getOwner();
        String subject = this.linkedin.getResolvedTitle(this.context);
        Message message = null;
        String text = "";
        if (StringUtils.isNotBlank((String)this.linkedin.getMessage())) {
            text = this.linkedin.getResolvedMessage(this.context);
            message = Message.of(subject, text);
        } else {
            TemplateContext props = new TemplateContext();
            this.context.getModel().getRelease().getReleaser().fillProps(props, this.context);
            text = this.linkedin.getResolvedMessageTemplate(this.context, props);
        }
        try {
            LinkedinSdk sdk = LinkedinSdk.builder(this.context.asImmutable()).accessToken(this.linkedin.getAccessToken()).connectTimeout(this.linkedin.getConnectTimeout()).readTimeout(this.linkedin.getReadTimeout()).dryrun(this.context.isDryrun()).build();
            if (null != message) {
                sdk.share(owner, message);
            } else {
                TemplateContext props = this.context.fullProps();
                props.set("linkedinSubject", (Object)subject);
                props.set("linkedinOwner", (Object)MustacheUtils.passThrough((String)"{{linkedinOwner}}"));
                MustacheUtils.applyTemplates((JReleaserLogger)this.context.getLogger(), (TemplateContext)props, (Map)this.linkedin.resolvedExtraProperties());
                text = MustacheUtils.applyTemplate((JReleaserLogger)this.context.getLogger(), (String)text, (TemplateContext)props);
                sdk.share(owner, subject, text);
            }
        }
        catch (LinkedinException e) {
            throw new AnnounceException((Throwable)e);
        }
    }
}

