/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.tool;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.api.signing.SigningException;
import org.jreleaser.sdk.command.Command;
import org.jreleaser.sdk.command.CommandException;
import org.jreleaser.sdk.command.CommandExecutor;
import org.jreleaser.sdk.tool.AbstractTool;

public class Minisign
extends AbstractTool {
    private static final String MINISIGN_PASSWORD = "MINISIGN_PASSWORD";

    public Minisign(JReleaserContext context, String version) {
        super(context, "minisign", version, true);
    }

    public void sign(Path keyFile, String password, Path input, Path destinationDir) throws SigningException {
        this.context.getLogger().info("{}", new Object[]{this.context.relativizeToBasedir(input)});
        try {
            Path signature = destinationDir.resolve(input.getFileName() + ".minisig");
            Command command = this.tool.asCommand().arg("-S").arg("-x").arg(signature.toAbsolutePath().toString()).arg("-s").arg(keyFile.toAbsolutePath().toString()).arg("-m").arg(input.toAbsolutePath().toString());
            ByteArrayInputStream stdin = new ByteArrayInputStream(password.getBytes(StandardCharsets.UTF_8));
            Command.Result result = this.executeCommand(() -> new CommandExecutor(this.context.getLogger(), CommandExecutor.Output.QUIET).executeCommand(command, (InputStream)stdin));
            if (result.getExitValue() != 0) {
                throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{result.getExitValue()}));
            }
        }
        catch (CommandException e) {
            throw new SigningException(RB.$((String)"ERROR_unexpected_error_signing", (Object[])new Object[]{input.toAbsolutePath()}), (Throwable)e);
        }
    }

    public void verify(Path keyFile, Path signature, Path input) throws SigningException {
        this.context.getLogger().debug("{}", new Object[]{this.context.relativizeToBasedir(signature)});
        try {
            Command command = this.tool.asCommand().arg("-V").arg("-x").arg(signature.toAbsolutePath().toString()).arg("-p").arg(keyFile.toAbsolutePath().toString()).arg("-q").arg("-m").arg(input.toAbsolutePath().toString());
            Command.Result result = this.executeCommand(() -> new CommandExecutor(this.context.getLogger(), CommandExecutor.Output.QUIET).executeCommand(command));
            if (result.getExitValue() != 0) {
                throw new CommandException(RB.$((String)"ERROR_command_execution_exit_value", (Object[])new Object[]{result.getExitValue()}));
            }
        }
        catch (CommandException e) {
            throw new SigningException(RB.$((String)"ERROR_signing_verify_signature", (Object[])new Object[]{this.context.relativizeToBasedir(signature)}), (Throwable)e);
        }
    }
}

