/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.nio.file.Path;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.ScoopPackager;
import org.jreleaser.model.internal.release.BaseReleaser;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.StringUtils;

public class ScoopPackagerProcessor
extends AbstractRepositoryPackagerProcessor<ScoopPackager> {
    public ScoopPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, TemplateContext props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(props);
    }

    @Override
    protected void fillPackagerProperties(TemplateContext props, Distribution distribution) {
        props.setOrEmpty("distributionJavaMainClass", distribution.getJava().getMainClass());
        props.setOrEmpty("distributionJavaMainModule", distribution.getJava().getMainModule());
        BaseReleaser releaser = this.context.getModel().getRelease().getReleaser();
        props.set("scoopBucketRepoUrl", (Object)releaser.getResolvedRepoUrl(this.context, ((ScoopPackager)this.packager).getRepository().getOwner(), ((ScoopPackager)this.packager).getRepository().getResolvedName()));
        props.set("scoopBucketRepoCloneUrl", (Object)releaser.getResolvedRepoCloneUrl(this.context, ((ScoopPackager)this.packager).getRepository().getOwner(), ((ScoopPackager)this.packager).getRepository().getResolvedName()));
        props.set("scoopRepositoryUrl", (Object)releaser.getResolvedRepoUrl(this.context, ((ScoopPackager)this.packager).getRepository().getOwner(), ((ScoopPackager)this.packager).getRepository().getResolvedName()));
        props.set("scoopRepositoryCloneUrl", (Object)releaser.getResolvedRepoCloneUrl(this.context, ((ScoopPackager)this.packager).getRepository().getOwner(), ((ScoopPackager)this.packager).getRepository().getResolvedName()));
        props.set("scoopPackageName", (Object)((ScoopPackager)this.packager).getPackageName());
        props.set("scoopCheckverUrl", this.resolveCheckverUrl(props));
        props.set("scoopAutoupdateUrl", this.resolveAutoupdateUrl(props, distribution));
        String autoupdateExtractDir = (String)props.get("distributionArtifactFileName");
        autoupdateExtractDir = autoupdateExtractDir.replace(this.context.getModel().getProject().getEffectiveVersion(), "$version");
        props.set("scoopAutoupdateExtractDir", (Object)autoupdateExtractDir);
    }

    private Object resolveCheckverUrl(TemplateContext props) {
        if (!((ScoopPackager)this.getPackager()).getCheckverUrl().contains("{{")) {
            return ((ScoopPackager)this.getPackager()).getCheckverUrl();
        }
        return Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)((ScoopPackager)this.getPackager()).getCheckverUrl(), (TemplateContext)props);
    }

    private Object resolveAutoupdateUrl(TemplateContext props, Distribution distribution) {
        String url = ((ScoopPackager)this.getPackager()).getAutoupdateUrl();
        if (StringUtils.isBlank((String)url)) {
            Artifact artifact = (Artifact)props.get("distributionArtifact");
            url = Artifacts.resolveDownloadUrl((JReleaserContext)this.context, (String)"scoop", (Distribution)distribution, (Artifact)artifact);
        }
        String artifactFile = (String)props.get("distributionArtifactFile");
        String projectVersion = (String)props.get("projectVersion");
        String tagName = (String)props.get("tagName");
        url = url.replace(projectVersion, "$version");
        artifactFile = artifactFile.replace(projectVersion, "$version");
        tagName = tagName.replace(projectVersion, "$version");
        TemplateContext copy = new TemplateContext(props);
        copy.set("projectVersion", (Object)"$version");
        copy.set("projectEffectiveVersion", (Object)"$version");
        copy.set("tagName", (Object)tagName);
        copy.set("artifactFile", (Object)artifactFile);
        return Templates.resolveTemplate((JReleaserLogger)this.context.getLogger(), (String)url, (TemplateContext)copy);
    }

    @Override
    protected void writeFile(Distribution distribution, String content, TemplateContext props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        Path outputFile = "manifest.json".equals(fileName = TemplateUtils.trimTplExtension((String)fileName)) ? outputDirectory.resolve("bucket").resolve(((ScoopPackager)this.packager).getPackageName().concat(".json")) : outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }
}

