'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const remoteReceived = require('./hooks/remote-received.cjs');
const jsxRuntime = require('react/jsx-runtime');

/**
 * Renders a remote React element to the host using React.
 */
function RemoteTextRenderer({
  remote,
  receiver
}) {
  const text = remoteReceived.useRemoteReceived(remote, receiver);
  return text ? /*#__PURE__*/jsxRuntime.jsx(jsxRuntime.Fragment, {
    children: text.data
  }) : null;
}

exports.RemoteTextRenderer = RemoteTextRenderer;
